#! /usr/bin/env python

import os
import shutil

import project


REPO = project.get_repo_base()
BENCHMARKS_DIR = os.environ["DOWNWARD_BENCHMARKS"]
SCP_LOGIN = "myname@myserver.com"
# REMOTE_REPOS_DIR = "/infai/badleo00/downward/experiments"
# If REVISION_CACHE is None, the default ./data/revision-cache is used.
REVISION_CACHE = os.environ.get("DOWNWARD_REVISION_CACHE")
if project.REMOTE:
    SUITE = ["gripper:prob01.pddl", "gripper:prob02.pddl", "gripper:prob03.pddl", "gripper:prob04.pddl", "gripper:prob05.pddl"]
    ENV = project.BaselSlurmEnvironment(email="leonhard.badenberg@unibas.ch", export=["PATH"])
else:
    SUITE = ["gripper:prob01.pddl", "gripper:prob02.pddl", "gripper:prob03.pddl", "gripper:prob04.pddl", "gripper:prob05.pddl"]
    ENV = project.LocalEnvironment(processes=2)

CONFIGS = [
    (h_nick, ["--search", f"astar({h})"])
    for h_nick, h in
    [
        #("cg", "cg(transform=adapt_costs(one))"),
        #("ff", "ff(transform=adapt_costs(one))"),
        ("lm_cut", "lmcut()"),
        ("implicit-dual", "operatorcounting([implicit_constraints()],lpsolver=cplex)"),
        ("implicit-primal", "implicit(lpsolver=cplex)"),
    ]
]
BUILD_OPTIONS = []
DRIVER_OPTIONS = ["--overall-time-limit", "30m"]
REVS = [
    ("working", "Test-LP"),
]
ATTRIBUTES = [
    "error",
    "run_dir",
    #"search_start_time",
    #"search_start_memory",
    "total_time",
    #"h_values",
    "coverage",
    "expansions",
    "memory",
    "cost",
    "expansions_until_next_jump",
    "initial_h_value",
    "planner_time",
    "search_time",
    project.EVALUATIONS_PER_TIME,
]

exp = project.FastDownwardExperiment(environment=ENV, revision_cache=REVISION_CACHE)
for config_nick, config in CONFIGS:
    for rev, rev_nick in REVS:
        algo_name = f"{rev_nick}:{config_nick}" if rev_nick else config_nick
        exp.add_algorithm(
            algo_name,
            REPO,
            rev,
            config,
            build_options=BUILD_OPTIONS,
            driver_options=DRIVER_OPTIONS,
        )
exp.add_suite(BENCHMARKS_DIR, SUITE)

exp.add_parser(exp.EXITCODE_PARSER)
exp.add_parser(exp.TRANSLATOR_PARSER)
exp.add_parser(exp.SINGLE_SEARCH_PARSER)
#exp.add_parser(project.DIR / "parser.py")
exp.add_parser(exp.PLANNER_PARSER)

exp.add_step("build", exp.build)
exp.add_step("start", exp.start_runs)
exp.add_fetcher(name="fetch")

#if not project.REMOTE:
#    exp.add_step("remove-eval-dir", shutil.rmtree, exp.eval_dir, ignore_errors=True)
#    project.add_scp_step(exp, SCP_LOGIN, REMOTE_REPOS_DIR)

project.add_absolute_report(
    exp, attributes=ATTRIBUTES, filter=[project.add_evaluations_per_time]
)

#attributes = ["expansions"]
#pairs = [
#    ("20.06:01-cg", "20.06:02-ff"),
#]
#suffix = "-rel" if project.RELATIVE else ""
#for algo1, algo2 in pairs:
#    for attr in attributes:
#        exp.add_report(
#            project.ScatterPlotReport(
#                relative=project.RELATIVE,
#                get_category=None if project.TEX else lambda run1, run2: run1["domain"],
#                attributes=[attr],
#                filter_algorithm=[algo1, algo2],
#                filter=[project.add_evaluations_per_time],
#                format="tex" if project.TEX else "png",
#            ),
#            name=f"{exp.name}-{algo1}-vs-{algo2}-{attr}{suffix}",
#        )

exp.run_steps()