#! /usr/bin/env python

import os
import shutil

from lab.reports import Attribute
from downward.reports.scatter import ScatterPlotReport


import project


REPO = project.get_repo_base()
BENCHMARKS_DIR = os.environ["DOWNWARD_BENCHMARKS"]
SCP_LOGIN = "myname@myserver.com"
# REMOTE_REPOS_DIR = "/infai/badleo00/downward/experiments"
# If REVISION_CACHE is None, the default ./data/revision-cache is used.
REVISION_CACHE = os.environ.get("DOWNWARD_REVISION_CACHE")
if project.REMOTE:
    SUITE = project.SUITE_OPTIMAL_STRIPS
    ENV = project.BaselSlurmEnvironment(email="leonhard.badenberg@unibas.ch", export=["PATH"])
else:
    SUITE = ["gripper:prob01.pddl", "gripper:prob02.pddl", "gripper:prob03.pddl", "gripper:prob04.pddl", "gripper:prob05.pddl"]
    ENV = project.LocalEnvironment(processes=2)

CONFIGS = [
    (h_nick, ["--search", f"astar({h})"])
    for h_nick, h in
    [
        #("cg", "cg(transform=adapt_costs(one))"),
        #("ff", "ff(transform=adapt_costs(one))"),
        ("implicit", "operatorcounting([implicit_constraints()],lpsolver=cplex)"),
        ("posthoc", "operatorcounting([pho_constraints()],lpsolver=cplex)"),
        ("both", "operatorcounting([pho_constraints(),implicit_constraints()],lpsolver=cplex)"),

    ]
]
BUILD_OPTIONS = []
DRIVER_OPTIONS = ["--overall-time-limit", "30m"]
REVS = [
    ("working", "04c021113cf6474efc40abece8e60ed8ecd2d028"),
]
ATTRIBUTES = [
    "error",
    "run_dir",
    #"search_start_time",
    #"search_start_memory",
    #"h_values",
    "coverage",
    "cost",
    "initial_h_value",
    "expansions_until_last_jump",
    "expansions",
    #"expansions_until_next_jump",
    "planner_time",
    "search_time",
    "total_time",
    "memory",
    project.EVALUATIONS_PER_TIME,
    Attribute("non-goal forks", absolute=True),
    Attribute("total fork abstractions", absolute=True),
]

exp = project.FastDownwardExperiment(environment=ENV, revision_cache=REVISION_CACHE)
for config_nick, config in CONFIGS:
    for rev, rev_nick in REVS:
        algo_name = f"{rev_nick}:{config_nick}" if rev_nick else config_nick
        exp.add_algorithm(
            algo_name,
            REPO,
            rev,
            config,
            build_options=BUILD_OPTIONS,
            driver_options=DRIVER_OPTIONS,
        )
exp.add_suite(BENCHMARKS_DIR, SUITE)

exp.add_parser(exp.EXITCODE_PARSER)
exp.add_parser(exp.TRANSLATOR_PARSER)
exp.add_parser(exp.SINGLE_SEARCH_PARSER)
#exp.add_parser(project.DIR / "parser.py")
exp.add_parser(exp.PLANNER_PARSER)
exp.add_parser("IMPLICIT_PARSER.py")

exp.add_step("build", exp.build)
exp.add_step("start", exp.start_runs)
exp.add_fetcher(name="fetch")
#exp.add_parse_again_step()

SCATTERATTRIBUTES = [
    "initial_h_value",
    "expansions_until_last_jump",
]


for attribute in SCATTERATTRIBUTES:
    implicit = "Implicit"
    other = "Post-Hoc"
    both = "Combined"

    def rename_algos(run):
        algo=run["algorithm"]
        if "implicit" in algo:
            run["algorithm"]= implicit
        elif "both" in algo:
            run["algorithm"]= both
        else:
            run["algorithm"]= other
        return True

    exp.add_report(
        ScatterPlotReport(
            attributes=[attribute],
            filter=[rename_algos],
            filter_algorithm=[implicit, other],
            scale="log",
            #get_category=domain_as_category,
            format="png",  # Use "tex" for pgfplots output.
        ),
        name=f"{attribute}-Implicit-vs-Post-Hoc",
    )
    exp.add_report(
        ScatterPlotReport(
            attributes=[attribute],
            filter=[rename_algos],
            filter_algorithm=[implicit, both],
            scale="log",
            #get_category=domain_as_category,
            format="png",  # Use "tex" for pgfplots output.
        ),
        name=f"{attribute}-Implicit-vs-Implicit+Post-Hoc",
    )
    exp.add_report(
        ScatterPlotReport(
            attributes=[attribute],
            filter=[rename_algos],
            filter_algorithm=[other, both],
            scale="log",
            #get_category=domain_as_category,
            format="png",  # Use "tex" for pgfplots output.
        ),
        name=f"{attribute}-Post-Hoc-vs-Implicit+Post-Hoc",
    )



#if not project.REMOTE:
#    exp.add_step("remove-eval-dir", shutil.rmtree, exp.eval_dir, ignore_errors=True)
#    project.add_scp_step(exp, SCP_LOGIN, REMOTE_REPOS_DIR)

project.add_absolute_report(
    exp, attributes=ATTRIBUTES, filter=[project.add_evaluations_per_time]
)

#attributes = ["expansions"]
#pairs = [
#    ("20.06:01-cg", "20.06:02-ff"),
#]
#suffix = "-rel" if project.RELATIVE else ""
#for algo1, algo2 in pairs:
#    for attr in attributes:
#        exp.add_report(
#            project.ScatterPlotReport(
#                relative=project.RELATIVE,
#                get_category=None if project.TEX else lambda run1, run2: run1["domain"],
#                attributes=[attr],
#                filter_algorithm=[algo1, algo2],
#                filter=[project.add_evaluations_per_time],
#                format="tex" if project.TEX else "png",
#            ),
#            name=f"{exp.name}-{algo1}-vs-{algo2}-{attr}{suffix}",
#        )

exp.run_steps()