#ifndef IMPLICIT_ABSTRACTIONS_IMPLICIT_H
#define IMPLICIT_ABSTRACTIONS_IMPLICIT_H

#include "../heuristic.h"
#include "../lp/lp_solver.h"
#include "../algorithms/priority_queues.h"
#include "../implicit_abstractions/cost_partitioning.h"
#include "../operator_counting/implicit_fork_constraints.h"

#include <memory>
#include <string>
#include <vector>


using namespace std;

namespace implicit {

class ForwardFork;
class ForkAbstraction;

class ImplicitHeuristic : public Heuristic {

    vector<ForwardFork> forward_forks;
    vector<ForkAbstraction> fork_abstractions;
    bool write_cout = false; //used for debugging
    lp::LPSolver lp_solver;
    bool use_dual;
    bool write_lp; //does not work with dual
    CostPartitioning cost_partitioning;
    ImplicitForkConstraints implicit_fork_constraints;
private:
    //int h;
protected:
    virtual int compute_heuristic(const State &ancestor_state) override;
public:
    explicit ImplicitHeuristic(const plugins::Options &opts);
    ~ImplicitHeuristic() = default;
    virtual bool dead_ends_are_reliable() const override;
};
}

#endif
