#include "implicit.h"

//#include "domain_transition_graph.h"
#include "forward_fork.h"
#include "fork_abstraction.h"
#include "cost_partitioning.h"

#include "../plugins/plugin.h"
#include "../task_utils/task_properties.h"
#include "../utils/logging.h"
#include "../task_utils/causal_graph.h"
#include "../operator_counting/implicit_fork_constraints.h"

#include <algorithm>
#include <cassert>
#include <limits>
#include <vector>

using namespace std;

namespace implicit {
    ImplicitHeuristic::ImplicitHeuristic(const plugins::Options &opts)
    : Heuristic(opts), lp_solver(opts.get<lp::LPSolverType>("lpsolver")), use_dual(opts.get<bool>("use_dual")),
            write_lp(opts.get<bool>("write_lp")), cost_partitioning(lp_solver), implicit_fork_constraints(lp_solver,opts) {
        if(log.is_at_least_normal()){
            log << "Initializing implicit abstraction heuristic..." << endl;
        }
        /*const causal_graph::CausalGraph &cg = causal_graph::get_causal_graph(
            task.get());
        //cg.dump(task_proxy);
        for (const VariableProxy &var : task_proxy.get_variables()) {
            forward_forks.emplace_back(cg, task_proxy, var.get_id());
        }
        for (ForwardFork &forward_fork : forward_forks) {
            fork_abstractions.emplace_back(forward_fork, task_proxy);
        }
        cout << "#forward forks: " << forward_forks.size() << ", #fork abstractions: " << fork_abstractions.size() << endl;*/
        //lp::LPSolver lp_solver(opts.get<lp::LPSolverType>("lpsolver"));
        //potentially allow uniform cp
        //Test initial state
        //cost_partitioning.update_constraints(task_proxy.get_initial_state(),lp_solver);
        //lp_solver.set_mip_gap(0);
        double infinity = lp_solver.get_infinity();
        if (use_dual) {
            named_vector::NamedVector<lp::LPVariable> variables;
            for (OperatorProxy op : task_proxy.get_operators()) {
                int op_cost = op.get_cost();
                variables.push_back(lp::LPVariable(0, infinity, op_cost, false));
            }
            lp::LinearProgram lp(lp::LPObjectiveSense::MINIMIZE, move(variables), {}, infinity);
            implicit_fork_constraints.initialize_constraints(task, lp);
            /*cout << "LP Variables: " << lp.get_variables().size() << endl;
            cout << "LP Constraints: " << lp.get_constraints().size() << endl;*/
            lp_solver.load_problem(lp);
        } else {
            lp::LinearProgram lp(lp::LPObjectiveSense::MAXIMIZE, {}, {}, infinity);
            cost_partitioning.initialize_constraints(task, lp);
            /*cout << "LP Variables: " << lp.get_variables().size() << endl;
            cout << "LP Constraints: " << lp.get_constraints().size() << endl;*/
            lp_solver.load_problem(lp);
        }
    }


bool ImplicitHeuristic::dead_ends_are_reliable() const {
    return false;
}

int ImplicitHeuristic::compute_heuristic(const State &ancestor_state) {
    State state = convert_ancestor_state(ancestor_state);
    //TODO figure out why I can't write lp for implicit_fork_constraints
    //setup_domain_transition_graphs();

    //Main implementation
    assert(!lp_solver.has_temporary_constraints());
    //cout << "LPSolver Constraints before adding temporary: " << lp_solver.get_num_constraints() << endl;
    bool dead_end = false;
    if (use_dual) {
        dead_end = implicit_fork_constraints.update_constraints(state, lp_solver);
    } else {
        dead_end = cost_partitioning.update_constraints(state, lp_solver);
    }
    //cout << "LPSolver Constraints after adding temporary: " << lp_solver.get_num_constraints() << endl;
    if (dead_end) {
        lp_solver.clear_temporary_constraints();
        return DEAD_END;
    }
    int heuristic;
    //cout << "trying to solve lp" << endl;
    lp_solver.solve();
    //cout << "lp solved" << endl;
    if (write_cout){
        cout << "LPSolver Variables: " << lp_solver.get_num_variables() << endl;
        cout << "LPSolver Objective: " << lp_solver.get_objective_value() << endl;
        cout << "LPSolver Constraints after adding temporary: " << lp_solver.get_num_constraints() << endl;
        write_cout = false;
    }
    if (write_lp){
        if (use_dual) {
            lp_solver.write_lp("fork-occ-dual");
        } else {
            lp_solver.write_lp("fork-cp-primal");
        }
        /*cout << "LPSolver Variables: " << lp_solver.get_num_variables() << endl;
        cout << "LPSolver Objective: " << lp_solver.get_objective_value() << endl;
        cout << "LPSolver Constraints after adding temporary: " << lp_solver.get_num_constraints() << endl;*/
        write_lp = false;
    }
    if (lp_solver.has_optimal_solution()) {
        double epsilon = 0.01;
        double objective_value = lp_solver.get_objective_value();
        heuristic = ceil(objective_value - epsilon);
    } else {
        //cout << "Could not find optimal LP solution" << endl;
        heuristic = DEAD_END;
    }
    lp_solver.clear_temporary_constraints();
    //cout << "Heuristic value: " << heuristic << endl;
    return heuristic;
}



//Initial Implementation attempts no longer needed (for now)
/*vector<vector<int>> compute_forks(const shared_ptr<AbstractTask> &task) {
    TaskProxy task_proxy(*task);
    int num_vars = task_proxy.get_variables().size();
    const causal_graph::CausalGraph &cg = causal_graph::get_causal_graph(task.get());
    vector<vector<int>> cg_forks(num_vars);
    for (int var_id = 0; var_id < num_vars; ++var_id) {
        const vector<int> &successors = cg.get_successors(var_id);
        cg_forks[var_id].insert(cg_forks[var_id].end(), successors.begin(), successors.end());
        utils::sort_unique(cg_forks[var_id]);
    }
    return cg_forks;
}*/

/*vector<vector<int>> compute_iforks(const shared_ptr<AbstractTask> &task) {
    TaskProxy task_proxy(*task);
    int num_vars = task_proxy.get_variables().size();
    const causal_graph::CausalGraph &cg = causal_graph::get_causal_graph(task.get());
    vector<vector<int>> cg_iforks(num_vars);
    for (int var_id = 0; var_id < num_vars; ++var_id) {
        const vector<int> &predecessors = cg.get_predecessors(var_id);
        cg_iforks[var_id].insert(cg_iforks[var_id].end(), predecessors.begin(), predecessors.end());
        utils::sort_unique(cg_iforks[var_id]);
    }
    return cg_iforks;
}*/

/*
vector<vector<int>> compute_forks(const shared_ptr<AbstractTask> &task) {
    TaskProxy task_proxy(*task);
    int num_vars = static_cast<int>(task_proxy.get_variables().size());
    const causal_graph::CausalGraph &cg = causal_graph::get_causal_graph(task.get());
    cg.dump(task_proxy);
    vector<vector<int>> cg_forks;
    cg_forks.reserve(num_vars);
    for (int var_id = 0; var_id < num_vars; ++var_id) {
        vector<int> successors = cg.get_successors(var_id);
        cg_forks.push_back(successors);
    }
    return cg_forks;
}

int get_root_domain(const shared_ptr<AbstractTask> &task, int root_id){
    TaskProxy task_proxy(*task);
    VariablesProxy variables = task_proxy.get_variables();
    int root_domain = variables[root_id].get_domain_size();
    return root_domain;
}

OperatorsProxy get_task_operators(const shared_ptr<AbstractTask> &task){
    TaskProxy task_proxy(*task);
    OperatorsProxy operators = task_proxy.get_operators();
    return operators;
}

class Fork {//Not sure how to access/construct operator proxy and variables proxy etc.
public:
    int root_id;
    vector<int> successors;
    int root_domain;
    //static TaskProxy task_proxy;

    Fork(int root_id, vector<int> successors, TaskProxy task_proxy){
        this->root_id = root_id;
        this->successors = successors;
        VariablesProxy variables = task_proxy.get_variables();
        this->root_domain = variables[root_id].get_domain_size();
        OperatorsProxy operators = task_proxy.get_operators();
    }
    //Functions to abstract root domain (probably should not have initial root domain as field but already abstracted)
    //Functions to abstract operators to unary ones (again probably only have unary operators as fields)
};


//creates a list of lists for each variable containing their predecessors in the causal graph
vector<vector<int>> compute_iforks(const shared_ptr<AbstractTask> &task) {
    TaskProxy task_proxy(*task);
    int num_vars = static_cast<int>(task_proxy.get_variables().size());
    const causal_graph::CausalGraph &cg = causal_graph::get_causal_graph(task.get());
    vector<vector<int>> cg_iforks;
    cg_iforks.reserve(num_vars);
    for (int var_id = 0; var_id < num_vars; ++var_id) {
        vector<int> predecessors = cg.get_predecessors(var_id);
        cg_iforks.push_back(predecessors);
    }
    return cg_iforks;
}

class IFork {
public:
    int root_id;//here the sink of the inverted fork
    vector<int> predecessors;
    //static TaskProxy task_proxy;

    IFork(int root_id, vector<int> predecessors, TaskProxy task_proxy){
        this->root_id = root_id;
        this->predecessors = predecessors;
        VariablesProxy variables = task_proxy.get_variables();
        OperatorsProxy operators = task_proxy.get_operators();
    }
    //Functions to abstract operators to unary ones (should probably only have unary operators as fields)
};//also put all the declarations in the header file*/


class ImplicitHeuristicFeature : public plugins::TypedFeature<Evaluator, ImplicitHeuristic> {
public:
    ImplicitHeuristicFeature() : TypedFeature("implicit") {
        document_title("Implicit abstraction heuristic");

        lp::add_lp_solver_option_to_feature(*this);
        Heuristic::add_options_to_feature(*this);
        add_option<bool>(
                "use_dual",
                "use the dual version of the lp instead of the cost_partitioning primal lp."
                "It is specified by implicit_fork_constraints within the operator counting framework.",
                "false");
        add_option<bool>(
                "write_lp",
                "writes the inital_state of the lp as a .lp file. Mainly used for debugging. Does not work when"
                "used together with the use_dual option.",
                "false");

        document_language_support("action costs", "supported");
        document_language_support("conditional effects", "not supported");
        document_language_support("axioms","not supported");

        document_property("admissible", "will be");
        document_property("consistent", "will see");
        document_property("safe", "will see");
        document_property("preferred operators", "probably not");
    }
};

static plugins::FeaturePlugin<ImplicitHeuristicFeature> _plugin;
}
