#include "forward_fork.h"

using namespace std;

namespace implicit {
/*ForwardFork::ForwardFork(const causal_graph::CausalGraph &cg, const TaskProxy &task_proxy, int root_id)
    : root_id(root_id),successors(cg.get_successors(root_id)){
    dump();
}*/
ForwardFork::ForwardFork(const causal_graph::CausalGraph &cg, const TaskProxy &task_proxy, int root_id)
    : root_id(root_id) {
    for (int successor_id : cg.get_successors(root_id)) {
        successors.emplace_back(successor_id);
    }
    for (const OperatorProxy &op : task_proxy.get_operators()) {
        operators.push_back(op);
    }
    /*for (const OperatorProxy &op : task_proxy.get_operators()) {
        if (op.is_axiom()) {
            continue;
        }
        create_successors(cg, op);
    }*/
    //dump();
}

/*void ForwardFork::create_successors(const causal_graph::CausalGraph &cg,
                                 const OperatorProxy &op) {
    for (int successor_id : cg.get_successors(root_id)) {
        bool op_has_precondition_on_root = false;
        bool op_has_effect_on_root = false;
        bool op_has_effect_on_successor = false;
        for (const auto &pre : op.get_preconditions()) {
            if (pre.get_variable().get_id() == root_id) {
                op_has_precondition_on_root = true;
                break;
            }
        }
        for (const auto &eff : op.get_effects()) {
            int eff_var_id = eff.get_fact().get_variable().get_id();
            if (eff_var_id == root_id) {
                op_has_effect_on_root = true;
            } else if (eff_var_id == successor_id) {
                op_has_effect_on_successor = true;
            }
        }
        if ((op_has_precondition_on_root || op_has_effect_on_root)
            && op_has_effect_on_successor) {
            successors.emplace_back(successor_id, op.get_id());
        }
    }
}*/


/*
void ForwardFork::get_precondition_successors(
    const causal_graph::CausalGraph &cg, const OperatorProxy &op) {
    vector<int> precondition_successors = cg.get_pre_to_eff(root_id);
    for (int successor_id : precondition_successors) {
        bool op_has_precondition = false;
        bool op_has_effect = false;
        for (const auto &pre : op.get_preconditions()) {
            if (pre.get_variable().get_id() == root_id) {
                op_has_precondition = true;
                break;
            }
        }
        for (const auto &eff : op.get_effects()) {
            if (eff.get_fact().get_variable().get_id() == successor_id) {
                op_has_effect = true;
                break;
            }
        }
        if (op_has_precondition && op_has_effect) {
            successors.emplace_back(successor_id, op.get_id());
        }
    }

}

void ForwardFork::get_effect_successors(
    const causal_graph::CausalGraph &cg, const OperatorProxy &op) {
    vector<int> effect_successors = cg.get_eff_to_eff(root_id);
    for (int successor_id : effect_successors) {
        bool op_has_effect_on_root = false;
        bool op_has_effect_on_successor = false;
        for (const auto &eff : op.get_effects()) {
            int eff_var_id = eff.get_fact().get_variable().get_id();
            if (eff_var_id == root_id) {
                op_has_effect_on_root = true;
            } else if (eff_var_id == successor_id) {
                op_has_effect_on_successor = true;
            }
        }
        if (op_has_effect_on_root && op_has_effect_on_successor) {
            successors.emplace_back(successor_id, op.get_id());
        }

    }
}
*/

void ForwardFork::dump() {
    cout << "Root ID: " << root_id << endl;
    cout << "Successors: ";
    for (ForkSuccessor successor : successors) {
        cout << "var_id: " << successor.var_id; // << " op_id: " << successor.op_id;
    }
    cout << endl;
}

int ForwardFork::get_root_id() {
    return root_id;
}

vector<ForkSuccessor> ForwardFork::get_successors() {
    return successors;
}

vector<int> ForwardFork::get_variables(){
    vector<int> variables = {root_id};
    for (ForkSuccessor successor : successors) {
        variables.push_back(successor.var_id);
    }
    return variables;
}

vector<OperatorProxy> ForwardFork::get_operators() {
    return operators;
}
}
