#ifndef FAST_DOWNWARD_FORK_ABSTRACTION_H
#define FAST_DOWNWARD_FORK_ABSTRACTION_H

#include "forward_fork.h"

using namespace std;

namespace implicit {
struct AbstractFact {
    int var_id;
    int value;
    string name;
    VariableProxy original_var;
    AbstractFact(int var_id, int value, string name, VariableProxy original_var)
                : var_id(var_id), value(value), name(name), original_var(original_var)
    {}
};
struct UnaryOperator {
    int original_op_id;
    int effect_id;
    AbstractFact unary_effect;
    vector<AbstractFact> preconditions;
    UnaryOperator(int original_op_id, int effect_id, AbstractFact unary_effect,
                  vector<AbstractFact> preconditions) : original_op_id(original_op_id), effect_id(effect_id),
                  unary_effect(unary_effect), preconditions(preconditions)
    {}
};
class ForkAbstraction {
    void create_root_dom_map (int domain_size);
    void create_unary_operators(const OperatorProxy &op);
    void dump(const TaskProxy &task_proxy);
public:
    int root_id;
    vector<int> variables;
    vector<int> root_dom_mapping;
    vector<ForkSuccessor> successors;
    vector<UnaryOperator> operators;
    vector<AbstractFact> initial_state;
    vector<AbstractFact> abstract_goal;
    ForkAbstraction(ForwardFork &forward_fork, const TaskProxy &task_proxy);
};
}

#endif
