#ifndef FAST_DOWNWARD_COST_PARTITIONING_H
#define FAST_DOWNWARD_COST_PARTITIONING_H

#include <cmath>
#include "../lp/lp_solver.h"
#include "fork_abstraction.h"
#include "../operator_counting/constraint_generator.h"

using namespace std;

class AbstractTask;
class State;

namespace lp {
class LinearProgram;
class LPSolver;
}

struct VectorHash {
    template <typename T>
    size_t operator()(const vector<T> &vec) const {
        size_t seed = vec.size();
        for (const T &value : vec) {
            seed ^= hash<T>()(value) + 0x9e3779b9 + (seed << 6) + (seed >> 2);
        }
        return seed;
    }
};

namespace implicit {
    using LPConstraints = named_vector::NamedVector<lp::LPConstraint>;
    using LPVariables = named_vector::NamedVector<lp::LPVariable>;
class CostPartitioning : public operator_counting::ConstraintGenerator{
    //LPVariables variables;
    //LPConstraints constraints;
    vector<ForwardFork> forward_forks;
    vector<ForkAbstraction> fork_abstractions;
    double infinity;
    //{fork_abstraction.root_id, operator_id, unary_operator.effect_id}
    unordered_map<vector<int>, int, VectorHash> fork_op_cost_indices;
    //{fork_abstraction.root_id, succ.var_id, dom_i, dom_j, root_value}
    //{fork_abstraction.root_id, succ.var_id, dom_i, root_seq.length}
    //{fork_abstraction.root_id}
    unordered_map<vector<int>, int, VectorHash> fork_var_indices;
    //<fork_abstraction.root_id, largest_domain_size>
    unordered_map<int, int> largest_domain_sizes;
    void create_additivity_constraints(const OperatorProxy &op, LPConstraints &constraints, LPVariables &variables);
    void create_fixed_root_fork_constraints(const ForkAbstraction &fork_abstraction, const TaskProxy &task_proxy,
                                            LPConstraints &constraints, LPVariables &variables);
    void create_root_seq_fork_variables(const ForkAbstraction &fork_abstraction, const TaskProxy &task_proxy,
                                        LPVariables &variables);
    void create_temporary_fork_constraints(const State &state, const ForkAbstraction &fork_abstraction,
                                           vector<lp::LPConstraint> &temp_constraints);
    void create_h_constraints(vector<int> &root_sequence, const ForkAbstraction &fork_abstraction,
                              vector<lp::LPConstraint> &temp_constraints);
    void add_goal_var_constraints(int root_seq_size, const ForkAbstraction &fork_abstraction,
                                         vector<lp::LPConstraint> &temp_constraints);
    void dump_variables(LPVariables &variables);
public:
    explicit CostPartitioning(const lp::LPSolver &lp_solver);
    /*
      Called upon initialization for the given task. Use this to add permanent
      constraints and perform other initialization.
    */
    void initialize_constraints(
            const shared_ptr<AbstractTask> &task, lp::LinearProgram &lp) override;

    /*
      Called before evaluating a state. Use this to add temporary constraints
      and to set bounds on permanent constraints for this state. All temporary
      constraints are removed automatically after the evalution.

      Returns true if a dead end was detected and false otherwise.
    */
    bool update_constraints(
            const State &state, lp::LPSolver &lp_solver) override;
};
}

#endif
