dual LogicalExpression::evaluateForAutodiffFwdVis(
        VectorXdual const& /*sf*/,
        VectorXdual const& /*af*/,
        int& /*tree_size*/,
        std::ostream& /*out*/) const {
    assert(false);
    return false;
}

/*****************************************************************
                           Atomics
*****************************************************************/

dual DeterministicStateFluent::evaluateForAutodiffFwdVis(
        VectorXdual const& sf,
        VectorXdual const& /*af*/,
        int& tree_size,
        std::ostream& out) const {
    assert(!isnan(sf[index].val));
    out << "n" << tree_size << " [label=\"Sf " << name <<": " << sf[index] << "\"]" << endl;
    return sf[index];
}

dual ProbabilisticStateFluent::evaluateForAutodiffFwdVis(
        VectorXdual const& sf,
        VectorXdual const& /*af*/,
        int& tree_size,
        std::ostream& out) const {
    assert(!isnan(sf[State::numberOfDeterministicStateFluents + index].val));
    out << "n" << tree_size << " [label=\"Sf " << name <<": " << sf[State::numberOfDeterministicStateFluents + index] << "\"]" << endl;
    return sf[State::numberOfDeterministicStateFluents + index];
}

dual ActionFluent::evaluateForAutodiffFwdVis(
        VectorXdual const& /*sf*/,
        VectorXdual const& af,
        int& tree_size,
        std::ostream& out) const {
    assert(!isnan(af[index].val));
    out << "n" << tree_size << " [label=\"Af " << name <<": " << af[index] << "\"]" << endl;
    return af[index];
}

dual NumericConstant::evaluateForAutodiffFwdVis(
        VectorXdual const& /*sf*/,
        VectorXdual const& /*af*/,
        int& tree_size,
        std::ostream& out) const {
    assert(!isnan(value));
    out << "n" << tree_size << " [label=\"c: " << value << "\"]" << endl;
    return value;
}

/*****************************************************************
                           Connectives
*****************************************************************/

dual Conjunction::evaluateForAutodiffFwdVis(
        VectorXdual const&  sf,
        VectorXdual const&  af,
        int& tree_size,
        std::ostream& out) const {
    // Conjunction a and b => a*b
    out << "n" << tree_size << " [label=\"conjunction\"]" << endl;
    int counter = tree_size;

    dual res = 1.0;
    for (auto e : exprs) {
        tree_size++;
        out << "n" << counter <<  " -> n" << tree_size << endl;
        res *= e->evaluateForAutodiffFwdVis(sf, af, tree_size, out);

        //if (MathUtils::doubleIsEqual(res.val, 0.0)) {
        //    return 0.0;
        //}
    }
    assert(!isnan(res.val));
    return res;
}

dual Disjunction::evaluateForAutodiffFwdVis(
        VectorXdual const&  sf,
        VectorXdual const&  af,
        int& tree_size,
        std::ostream& out) const {
    // Disjunction: a or b => 1-((1-a)*(1-b))
    out << "n" << tree_size << " [label=\"disjunction\"]" << endl;
    int counter = tree_size;

    dual res = 1.0; // The empty disjunction is false
    for (auto e : exprs) {
        tree_size++;
        out << "n" << counter <<  " -> n" << tree_size << endl;
        res *= 1.0 - e->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
        //if (MathUtils::doubleIsEqual(res.val, 0.0)) {
        //    return 1.0;
        //}
    }
    assert(!isnan(res.val));
    return 1 - res;
}

dual Addition::evaluateForAutodiffFwdVis(
        VectorXdual const&  sf,
        VectorXdual const&  af,
        int& tree_size,
        std::ostream& out) const {
    out << "n" << tree_size << " [label=\"+\"]" << endl;
    int counter = tree_size;

    dual res = 0.0;
    for (auto e : exprs) {
//        dual add = e->evaluateForAutodiffFwdVis(sf, af, ++tree_size);
        tree_size++;
        out << "n" << counter <<  " -> n" << tree_size << endl;
        res += e->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
    }
    assert(!isnan(res.val));
    return res;
}

dual Subtraction::evaluateForAutodiffFwdVis(
        VectorXdual const&  sf,
        VectorXdual const&  af,
        int& tree_size,
        std::ostream& out) const {
    out << "n" << tree_size << " [label=\"-\"]" << endl;
    int counter = tree_size;

    tree_size++;
    out << "n" << counter <<  " -> n" << tree_size << endl;
    dual res = exprs[0]->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
    for (unsigned int i = 1; i < exprs.size(); ++i) {
        tree_size++;
        out << "n" << counter <<  " -> n" << tree_size << endl;
        res -= exprs[i]->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
    }
    assert(!isnan(res.val));
    return res;
}

dual Multiplication::evaluateForAutodiffFwdVis(
        VectorXdual const&  sf,
        VectorXdual const&  af,
        int& tree_size,
        std::ostream& out) const {
    out << "n" << tree_size << " [label=\"*\"]" << endl;
    int counter = tree_size;
    dual res = 1.0;
    for (auto e : exprs) {
        tree_size++;
        out << "n" << counter <<  " -> n" << tree_size << endl;
        res *= e->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
        //if (MathUtils::doubleIsEqual(res.val, 0.0)) {
        //    return 0.0;
        //}
    }
    assert(!isnan(res.val));
    return res;
}

dual Division::evaluateForAutodiffFwdVis(
        VectorXdual const&  sf,
        VectorXdual const&  af,
        int& tree_size,
        std::ostream& out) const {
    out << "n" << tree_size << " [label=\"/\"]" << endl;
    int counter = tree_size;
    tree_size++;
    out << "n" << counter <<  " -> n" << tree_size << endl;
    dual res= exprs[0]->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
    for (unsigned int i = 1; i < exprs.size(); ++i) {
        //if (MathUtils::doubleIsEqual(res.val, 0.0)) {
        //    return 0.0;
        //}
        tree_size++;
        out << "n" << counter <<  " -> n" << tree_size << endl;
        dual exprRes = exprs[i]->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
        assert(!MathUtils::doubleIsEqual(exprRes.val, 0.0));
        res /= exprRes;
    }
    assert(!isnan(res.val));
    return res;
}

/*****************************************************************
                          Unaries
*****************************************************************/

dual Negation::evaluateForAutodiffFwdVis(
        VectorXdual const&  sf,
        VectorXdual const&  af,
        int& tree_size,
        std::ostream& out) const {
    // Negation: not a => 1-a
    out << "n" << tree_size << " [label=\"!\"]" << endl;
    out << "n" << tree_size <<  " -> n" << tree_size+1 << endl;
    tree_size++;

    dual res = 1.0 - expr->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
    assert(!isnan(res.val));
    return res;
}

dual ExponentialFunction::evaluateForAutodiffFwdVis(const VectorXdual &sf, const VectorXdual &af, int &tree_size,
                                                    std::ostream &out) const {
    out << "n" << tree_size << " [label=\"exp\"]" << endl;
    out << "n" << tree_size <<  " -> n" << tree_size+1 << endl;
    tree_size++;
    dual res = exp(expr->evaluateForAutodiffFwdVis(sf, af, tree_size, out));
    assert(!isnan(res.val));
    return res;
}

/*****************************************************************
                   Probability Distributions
*****************************************************************/

dual BernoulliDistribution::evaluateForAutodiffFwdVis(
        VectorXdual const&  sf,
        VectorXdual const&  af,
        int& tree_size,
std::ostream& out) const {
    out << "n" << tree_size << " [label=\"Bernoulli\"]" << endl;
    out << "n" << tree_size <<  " -> n" << tree_size+1 << endl;
    tree_size++;

    dual res = expr->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
    assert(!isnan(res.val));
    return res;
}

/*****************************************************************
                         Conditionals
*****************************************************************/

dual MultiConditionChecker::evaluateForAutodiffFwdVis(
        VectorXdual const&  sf,
        VectorXdual const&  af,
        int& tree_size,
        std::ostream& out) const {
    // MultiConditionChecker: if a then b else if c then d => a * b + (1-a) * c * d
    out << "n" << tree_size << " [label=\"multi\"]" << endl;
    int counter = tree_size;

    dual condRes;
    dual effRes;
    dual prevCond = 1.0;
    dual res = 0.0;
    for (unsigned int index = 0; index < conditions.size(); ++index) {
        tree_size++;
        out << "n" << counter <<  " -> n" << tree_size << endl;
        condRes = conditions[index]->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
        assert(!isnan(condRes.val));
        tree_size++;
        out << "n" << counter <<  " -> n" << tree_size << endl;
        effRes = effects[index]->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
        assert(!isnan(effRes.val));
        res += prevCond * condRes * effRes;
        prevCond *= (1.0 - condRes.val);
        assert(!isnan(prevCond.val));
    }
    assert(!isnan(res.val));
    return res;
}

/*****************************************************************
                           Equalities
*****************************************************************/

dual EqualsExpression::evaluateForAutodiffFwdVis(
        VectorXdual const&  sf,
        VectorXdual const&  af,
        int& tree_size,
    std::ostream& out) const {
    assert(exprs.size() == 2);
    out << "n" << tree_size << " [label=\"=\"]" << endl;

    tree_size++;
    // a = b <=> (1 -(a < b)) * (1 - (b < a))
    dual lhs = exprs[0]->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
    dual rhs = exprs[1]->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
    dual res = (1 / (1 + exp(rhs - lhs - 0.5)))-(1 / (1 + exp(rhs - lhs + 0.5)));
    assert(!isnan(res.val));
    return res;
}

dual GreaterExpression::evaluateForAutodiffFwdVis(
        VectorXdual const&  sf,
        VectorXdual const&  af,
        int& tree_size,
    std::ostream& out) const {
    assert(exprs.size() == 2);
    out << "n" << tree_size << " [label=\">\"]" << endl;

    tree_size++;
    dual lhs = exprs[0]->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
    dual rhs = exprs[1]->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
    dual res = 1 / (1 + exp(10 * (rhs - lhs)));
    assert(!isnan(res.val));
    return res;
}

dual LowerExpression::evaluateForAutodiffFwdVis(
        VectorXdual const&  sf,
        VectorXdual const&  af,
        int& tree_size,
    std::ostream& out) const {
    assert(exprs.size() == 2);
    out << "n" << tree_size << " [label=\"<\"]" << endl;

    tree_size++;
    dual lhs = exprs[0]->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
    dual rhs = exprs[1]->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
    dual res = 1 / (1 + exp(10 * (lhs - rhs)));
    assert(!isnan(res.val));
    return res;
}

dual GreaterEqualsExpression::evaluateForAutodiffFwdVis(
        VectorXdual const&  sf,
        VectorXdual const&  af,
        int& tree_size,
    std::ostream& out) const {
    assert(exprs.size() == 2);
    out << "n" << tree_size << " [label=\">=\"]" << endl;

    tree_size++;
    // 1-((1-a)*(1-b))
    dual lhs = exprs[0]->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
    dual rhs = exprs[1]->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
    dual res = 1 / (1 + exp(10 * (rhs - lhs)));
    assert(!isnan(res.val));
    return res;
}

dual LowerEqualsExpression::evaluateForAutodiffFwdVis(
        VectorXdual const&  sf,
        VectorXdual const&  af,
        int& tree_size,
    std::ostream& out) const {
    assert(exprs.size() == 2);
    out << "n" << tree_size << " [label=\"<=\"]" << endl;

    tree_size++;
    dual lhs = exprs[0]->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
    dual rhs = exprs[1]->evaluateForAutodiffFwdVis(sf, af, tree_size, out);
    dual res = 1 / (1 + exp(10 * (lhs - rhs)));
    assert(!isnan(res.val));
    return res;
}