var LogicalExpression::evaluateForAutodiffRev(
        VectorXvar& /*sf*/,
        VectorXvar& /*af*/) const {
    assert(false);
    return false;
}

/*****************************************************************
                           Atomics
*****************************************************************/

var DeterministicStateFluent::evaluateForAutodiffRev(
        VectorXvar& sf,
        VectorXvar& /*af*/) const {
    return sf[index];
}

var ProbabilisticStateFluent::evaluateForAutodiffRev(
        VectorXvar& sf,
        VectorXvar& /*af*/) const {
    return sf[State::numberOfDeterministicStateFluents + index];
}

var ActionFluent::evaluateForAutodiffRev(
        VectorXvar& /*sf*/,
        VectorXvar& af) const {
    return af[index];
}

var NumericConstant::evaluateForAutodiffRev(
        VectorXvar& /*sf*/,
        VectorXvar& /*af*/) const {
    return value;
}

/*****************************************************************
                           Connectives
*****************************************************************/

var Conjunction::evaluateForAutodiffRev(
        VectorXvar&  sf,
        VectorXvar&  af) const {
    // Conjunction a and b => a*b
    var res = 1.0;
    for (auto e : exprs) {
        res *= e->evaluateForAutodiffRev(sf, af);

        if (MathUtils::doubleIsEqual(res.expr->val, 0.0)) {
            return 0.0;
        }
    }
    return res;
}

var Disjunction::evaluateForAutodiffRev(
        VectorXvar&  sf,
        VectorXvar&  af) const {
    // Disjunction: a or b => 1-((1-a)*(1-b))
    var res = 1.0; // The empty disjunction is false
    for (auto e : exprs) {
        res *= 1.0 - e->evaluateForAutodiffRev(sf, af);
        if (MathUtils::doubleIsEqual(res.expr->val, 0.0)) {
            return 1.0;
        }
    }
    return 1 - res;
}

var Addition::evaluateForAutodiffRev(
        VectorXvar&  sf,
        VectorXvar&  af) const {
    var res = 0.0;
    for(auto e : exprs){
        res += e->evaluateForAutodiffRev(sf,af);
    }
    return res;
}

var Subtraction::evaluateForAutodiffRev(
        VectorXvar&  sf,
        VectorXvar&  af) const {
    var res = exprs[0]->evaluateForAutodiffRev(sf, af);
    for (unsigned int i = 1; i < exprs.size(); ++i) {
        res -= exprs[i]->evaluateForAutodiffRev(sf, af);
    }
    return res;
}

var Multiplication::evaluateForAutodiffRev(
        VectorXvar&  sf,
        VectorXvar&  af) const {
    var res = 1.0;
    for (auto e : exprs) {
        res *= e->evaluateForAutodiffRev(sf, af);
        if (MathUtils::doubleIsEqual(res.expr->val, 0.0)) {
            return 0.0;
        }
    }
    return res;
}

var Division::evaluateForAutodiffRev(
        VectorXvar&  sf,
        VectorXvar&  af) const {
    var res= exprs[0]->evaluateForAutodiffRev(sf, af);
    for (unsigned int i = 1; i < exprs.size(); ++i) {
        if (MathUtils::doubleIsEqual(res.expr->val, 0.0)) {
            return 0.0;
        }

        var exprRes = exprs[i]->evaluateForAutodiffRev(sf, af);
        assert(!MathUtils::doubleIsEqual(exprRes.expr->val, 0.0));
        res /= exprRes;
    }
    return res;
}

/*****************************************************************
                          Unaries
*****************************************************************/

var Negation::evaluateForAutodiffRev(
        VectorXvar&  sf,
        VectorXvar&  af) const {
    // Negation: not a => 1-a
    return 1.0 - expr->evaluateForAutodiffRev(sf, af);
}

/*****************************************************************
                   Probability Distributions
*****************************************************************/

var BernoulliDistribution::evaluateForAutodiffRev(
        VectorXvar&  sf,
        VectorXvar&  af) const {
    return expr->evaluateForAutodiffRev(sf, af);
}

/*****************************************************************
                         Conditionals
*****************************************************************/

var MultiConditionChecker::evaluateForAutodiffRev(
        VectorXvar&  sf,
        VectorXvar&  af) const {
    // MultiConditionChecker: if a then b else if c then d => a * b + (1-a) * c * d
    var condRes;
    var effRes;
    var prevCond = 1.0;
    var res = 0.0;
    for (unsigned int index = 0; index < conditions.size(); ++index) {
        condRes = conditions[index]->evaluateForAutodiffRev(sf, af);
        effRes = effects[index]->evaluateForAutodiffRev(sf, af);
        res += prevCond * condRes * effRes;
        prevCond *= 1.0 - condRes;
    }
    return res;
}

/*****************************************************************
                           Equalities
*****************************************************************/

var EqualsExpression::evaluateForAutodiffRev(
        VectorXvar&  sf,
        VectorXvar&  af) const {
    assert(exprs.size() == 2);

    // a = b <=> (1 -(a < b)) * (1 - (b < a))
    var lhs = exprs[0]->evaluateForAutodiffRev(sf, af);
    var rhs = exprs[1]->evaluateForAutodiffRev(sf, af);
    return (1 - (1 / (1 + exp(rhs - lhs)))) * (1 - (1 / (1 + exp(lhs - rhs))));
}

var GreaterExpression::evaluateForAutodiffRev(
        VectorXvar&  sf,
        VectorXvar&  af) const {
    assert(exprs.size() == 2);

    var lhs = exprs[0]->evaluateForAutodiffRev(sf, af);
    var rhs = exprs[1]->evaluateForAutodiffRev(sf, af);
    return 1 / (1 + exp(rhs - lhs));
}

var LowerExpression::evaluateForAutodiffRev(
        VectorXvar&  sf,
        VectorXvar&  af) const {
    assert(exprs.size() == 2);

    var lhs = exprs[0]->evaluateForAutodiffRev(sf, af);
    var rhs = exprs[1]->evaluateForAutodiffRev(sf, af);
    return 1 / (1 + exp(lhs - rhs));
}

var GreaterEqualsExpression::evaluateForAutodiffRev(
        VectorXvar&  sf,
        VectorXvar&  af) const {
    assert(exprs.size() == 2);

    // 1-((1-a)*(1-b))
    var lhs = exprs[0]->evaluateForAutodiffRev(sf, af);
    var rhs = exprs[1]->evaluateForAutodiffRev(sf, af);
    return 1 - ((1 - (1 / (1 + exp(rhs - lhs)))) * (1 - ((1 - (1 / (1 + exp(rhs - lhs)))) * (1 - (1 / (1 + exp(lhs - rhs)))))));
}

var LowerEqualsExpression::evaluateForAutodiffRev(
        VectorXvar&  sf,
        VectorXvar&  af) const {
    assert(exprs.size() == 2);

    var lhs = exprs[0]->evaluateForAutodiffRev(sf, af);
    var rhs = exprs[1]->evaluateForAutodiffRev(sf, af);
    return 1 - ((1 - (1 / (1 + exp(lhs - rhs)))) * (1 - ((1 - (1 / (1 + exp(rhs - lhs)))) * (1 - (1 / (1 + exp(lhs - rhs)))))));
}