dual LogicalExpression::evaluateForAutodiffFwd(
        VectorXdual const& /*sf*/,
        VectorXdual const& /*af*/) const {
    cout<<"Logical Expression not implemented."<<endl;
    assert(false);
    return false;
}

/*****************************************************************
                           Atomics
*****************************************************************/

dual DeterministicStateFluent::evaluateForAutodiffFwd(
        VectorXdual const& sf,
        VectorXdual const& /*af*/) const {
    assert(!isnan(sf[index].val));
    return sf[index];
}

dual ProbabilisticStateFluent::evaluateForAutodiffFwd(
        VectorXdual const& sf,
        VectorXdual const& /*af*/) const {
    assert(!isnan(sf[State::numberOfDeterministicStateFluents + index].val));
    return sf[State::numberOfDeterministicStateFluents + index];
}

dual ActionFluent::evaluateForAutodiffFwd(
        VectorXdual const& /*sf*/,
        VectorXdual const& af) const {
    assert(index < af.size());
    assert(index >= 0 );
    assert(!isnan(af[index].val));
    return af[index];
}

dual NumericConstant::evaluateForAutodiffFwd(
        VectorXdual const& /*sf*/,
        VectorXdual const& /*af*/) const {
    assert(!isnan(value));
    return value;
}

/*****************************************************************
                           Connectives
*****************************************************************/

dual Conjunction::evaluateForAutodiffFwd(
        VectorXdual const&  sf,
        VectorXdual const&  af) const {
    // Conjunction a and b => a*b
    dual res = 1.0;
    for (auto e : exprs) {
        res *= e->evaluateForAutodiffFwd(sf, af);

        if (MathUtils::doubleIsEqual(res.val, 0.0)) {
            return 0.0;
        }
    }
    assert(!isnan(res.val));
    return res;
}

dual Disjunction::evaluateForAutodiffFwd(
        VectorXdual const&  sf,
        VectorXdual const&  af) const {
    // Disjunction: a or b => 1-((1-a)*(1-b))
    dual res = 1.0; // The empty disjunction is false
    for (auto e : exprs) {
        res *= 1.0 - e->evaluateForAutodiffFwd(sf, af);
        if (MathUtils::doubleIsEqual(res.val, 0.0)) {
            return 1.0;
        }
    }
    assert(!isnan(res.val));
    return 1 - res;
}

dual Addition::evaluateForAutodiffFwd(
        VectorXdual const&  sf,
        VectorXdual const&  af) const {
    dual res = 0.0;
    for (auto e : exprs) {
        res += e->evaluateForAutodiffFwd(sf, af);
    }
    assert(!isnan(res.val));
    return res;
}

dual Subtraction::evaluateForAutodiffFwd(
        VectorXdual const&  sf,
        VectorXdual const&  af) const {
    dual res = exprs[0]->evaluateForAutodiffFwd(sf, af);
    for (unsigned int i = 1; i < exprs.size(); ++i) {
        res -= exprs[i]->evaluateForAutodiffFwd(sf, af);
    }
    assert(!isnan(res.val));
    return res;
}

dual Multiplication::evaluateForAutodiffFwd(
        VectorXdual const&  sf,
        VectorXdual const&  af) const {
    dual res = 1.0;
    for (auto e : exprs) {
        res *= e->evaluateForAutodiffFwd(sf, af);
        if (MathUtils::doubleIsEqual(res.val, 0.0)) {
            return 0.0;
        }
    }
    assert(!isnan(res.val));
    return res;
}

dual Division::evaluateForAutodiffFwd(
        VectorXdual const&  sf,
        VectorXdual const&  af) const {
    dual res= exprs[0]->evaluateForAutodiffFwd(sf, af);
    for (unsigned int i = 1; i < exprs.size(); ++i) {
        if (MathUtils::doubleIsEqual(res.val, 0.0)) {
            return 0.0;
        }
        dual exprRes = exprs[i]->evaluateForAutodiffFwd(sf, af);
        assert(!MathUtils::doubleIsEqual(exprRes.val, 0.0));
        res /= exprRes;
    }
    assert(!isnan(res.val));
    return res;
}

/*****************************************************************
                          Unaries
*****************************************************************/

dual Negation::evaluateForAutodiffFwd(
        VectorXdual const&  sf,
        VectorXdual const&  af) const {
    // Negation: not a => 1-a
    dual res = 1.0 - expr->evaluateForAutodiffFwd(sf, af);
    assert(!isnan(res.val));
    return res;
}

dual ExponentialFunction::evaluateForAutodiffFwd(const VectorXdual &sf, const VectorXdual &af) const {
    dual res = exp(expr->evaluateForAutodiffFwd(sf,af));
    assert(!isnan(res.val));
    return res;
}

/*****************************************************************
                   Probability Distributions
*****************************************************************/


dual BernoulliDistribution::evaluateForAutodiffFwd(
        VectorXdual const&  sf,
        VectorXdual const&  af) const {
    dual res = expr->evaluateForAutodiffFwd(sf, af);
    assert(!isnan(res.val));
    return res;
}

/*****************************************************************
                         Conditionals
*****************************************************************/

dual MultiConditionChecker::evaluateForAutodiffFwd(
        VectorXdual const&  sf,
        VectorXdual const&  af) const {
    // MultiConditionChecker: if a then b else if c then d => a * b + (1-a) * c * d
    dual condRes;
    dual effRes;
    dual prevCond = 1.0;
    dual res = 0.0;
    for (unsigned int index = 0; index < conditions.size(); ++index) {
        condRes = conditions[index]->evaluateForAutodiffFwd(sf, af);
        assert(!isnan(condRes.val));
        effRes = effects[index]->evaluateForAutodiffFwd(sf, af);
        assert(!isnan(effRes.val));
        res += prevCond * condRes * effRes;
        prevCond *= (1.0 - condRes);
        assert(!isnan(prevCond.val));
    }
    assert(!isnan(res.val));
    return res;
}

/*****************************************************************
                           Equalities
*****************************************************************/

dual EqualsExpression::evaluateForAutodiffFwd(
        VectorXdual const&  sf,
        VectorXdual const&  af) const {
    assert(exprs.size() == 2);
    // a = b <=> (1 -(a < b)) * (1 - (b < a))


    // a = b <=> sigma(a-b+0.5)-sigma(a-b-0.5)
    dual lhs = exprs[0]->evaluateForAutodiffFwd(sf, af);
    dual rhs = exprs[1]->evaluateForAutodiffFwd(sf, af);
    //dual res = (1 - (1 / (1 + exp(rhs - lhs)))) * (1 - (1 / (1 + exp(lhs - rhs))));
    dual res = (1 / (1 + exp(rhs - lhs - 0.5)))-(1 / (1 + exp(rhs - lhs + 0.5)));
    assert(!isnan(res.val));
    return res;
}

dual GreaterExpression::evaluateForAutodiffFwd(
        VectorXdual const&  sf,
        VectorXdual const&  af) const {
    assert(exprs.size() == 2);
    dual lhs = exprs[0]->evaluateForAutodiffFwd(sf, af);
    dual rhs = exprs[1]->evaluateForAutodiffFwd(sf, af);
    dual res = 1 / (1 + exp(10 * (rhs - lhs)));
    assert(!isnan(res.val));
    return res;
}

dual LowerExpression::evaluateForAutodiffFwd(
        VectorXdual const&  sf,
        VectorXdual const&  af) const {
    assert(exprs.size() == 2);
    dual lhs = exprs[0]->evaluateForAutodiffFwd(sf, af);
    dual rhs = exprs[1]->evaluateForAutodiffFwd(sf, af);
    dual res = 1 / (1 + exp(10 * (lhs - rhs)));
    assert(!isnan(res.val));
    return res;
}

dual GreaterEqualsExpression::evaluateForAutodiffFwd(
        VectorXdual const&  sf,
        VectorXdual const&  af) const {
    assert(exprs.size() == 2);
    // 1-((1-a)*(1-b))
    // a >= b <=> sigma(10*(a-b))
    dual lhs = exprs[0]->evaluateForAutodiffFwd(sf, af);
    dual rhs = exprs[1]->evaluateForAutodiffFwd(sf, af);
    //dual res = 1 - ((1 - (1 / (1 + exp(rhs - lhs)))) * (1 - ((1 - (1 / (1 + exp(rhs - lhs)))) * (1 - (1 / (1 + exp(lhs - rhs)))))));
    dual res = 1 / (1 + exp(10 * (rhs - lhs)));
    assert(!isnan(res.val));
    return res;
}

dual LowerEqualsExpression::evaluateForAutodiffFwd(
        VectorXdual const&  sf,
        VectorXdual const&  af) const {
    assert(exprs.size() == 2);
    dual lhs = exprs[0]->evaluateForAutodiffFwd(sf, af);
    dual rhs = exprs[1]->evaluateForAutodiffFwd(sf, af);
    //dual res = 1 - ((1 - (1 / (1 + exp(lhs - rhs)))) * (1 - ((1 - (1 / (1 + exp(rhs - lhs)))) * (1 - (1 / (1 + exp(lhs - rhs)))))));
    dual res = 1 / (1 + exp(10 * (lhs - rhs)));
    assert(!isnan(res.val));
    return res;
}