#!/usr/bin/env python
import argparse
import glob
import os
import shutil
import sys
import re

from graphviz import Digraph
import pyparsing as pp


def get_num_objects(expr):
    tmp = 0
    nodes = 0
    branches = 0
    dash = False
    for obj in expr:
        if obj == '-':
            dash = True
        elif dash and obj == 'node':
            nodes = tmp
            tmp = 0
        elif dash and obj == 'branch':
            branches = tmp
            tmp = 0
        else:
            tmp += 1

    return (nodes, branches)
def get_cur_obj(expr):
    maxNode = -1
    maxBranch = -1

    rex = re.compile('(n|b)(\d+)')

    for e in list(expr):
        if e[0] == 'is_in_graph':
            m = rex.match(e[1])
            n = int(m.group(2))
            if m.group(1) == 'n':
                maxNode = max(maxNode, n)
            if m.group(1) == 'b':
                maxBranch = max(maxBranch, n)

    return (maxNode, maxBranch)


def get_cur_predicates(cNode, cBranch):
    return [f'(cur_obj n{cNode +1})', f'(cur_obj b{cBranch +1})']

def get_order_predicates(nNode, nBranch):
    preds = []
    for n in range(nNode-1):
        preds.append(f'(next_obj n{n} n{n+1})')
    for n in range(nBranch-1):
        preds.append(f'(next_obj b{n} b{n+1})')
    return preds


def parse_pddl(text):
    expr = pp.nestedExpr()
    parsed = expr.parseString(text)[0]
    
    
    for expr in parsed:
        if expr[0] == ':objects':
            nodes, branches = get_num_objects(expr[1:])
    
        if expr[0] == ':init':
            cur_node, cur_branch = get_cur_obj(expr[1:])
    
    print(nodes, branches, cur_node, cur_branch)
    predicates = get_cur_predicates(cur_node, cur_branch)
    predicates += get_order_predicates(nodes, branches)
    return predicates

def main():

    folder = 'model/no-derived-ordered/'
    
    files = os.listdir(folder)
    
    for file in files:
        if file != 'domain.pddl':
            process_file(os.path.join(folder, file))

def process_file(file):
    print(f"Processing file: {file}")
    with open(file, "r+") as f:
        s = f.read()
        result = parse_pddl(s);
        result = "\n".join(result)

        newFile = s.replace(':init', f':init\n\n{result}\n\n')    
        
        # print(newFile)
        f.seek(0)
        f.write(newFile)
        f.truncate()
    pass


if __name__ == "__main__":
    main()
