(define (domain ordered)

(:requirements :strips :typing :negative-preconditions :equality :disjunctive-preconditions :derived-predicates :action-costs :conditional-effects)

(:types
  graphobj - object
  node branch - graphobj
)

(:predicates
  (n_is_parent ?n_parent ?n_child - node)
  (b_points_to ?b - branch ?n - node)
  (n_is_copy_of ?n1 ?n2 - node)
  (is_in_graph ?bn - graphobj)
  (is_head ?bn - graphobj) ; node or branch can be HEAD
  
  (next_obj ?o1 ?o2)
  (cur_obj ?o)
  
  ; === STATE ===
  (mode_rebase)
  (rebase_state ?head ?target)
  (rebase_to_copy ?n )
  (rebase_is_copied ?n - node) 
  ; === DERIVED === 
  (n_is_head ?n - node)
  (n_is_ancestor ?ancestor ?base - node)
  (n_is_first_common_ancestor ?n_common ?n1 ?n2 - node)
)

(:functions
  (total-cost)
)

; derived predicate that holds true when base node is connected 
; to the ancestor node via other nodes with the n_is_child predicate
(:derived (n_is_ancestor ?ancestor ?base - node)
  (or 
    (n_is_parent ?ancestor ?base) ; base is the direct child of the ancestor
    (exists (?n - node)          ; base is child of node which is itself connected to the ancester node
      (and 
        (n_is_parent ?n ?base) 
        (n_is_ancestor ?ancestor ?n)))
  )
)


; node is head if head pointer points to it 
; or if its branch is head
(:derived (n_is_head ?n - node)
  (or 
    (is_head ?n)
    (exists (?b - branch) 
      (and 
        (b_points_to ?b ?n) 
        (is_head ?b))))
)


; gives the closest common ancestor of two nodes
(:derived (n_is_first_common_ancestor ?n_common ?n1 ?n2 - node)
  (and
    (n_is_ancestor ?n_common ?n1)
    (n_is_ancestor ?n_common ?n2)
    (not (= ?n1 ?n2))
    (not (exists (?n_child - node) 
      (and
        (n_is_parent ?n_common ?n_child)
        (n_is_ancestor ?n_child ?n1)
        (n_is_ancestor ?n_child ?n2))))
  )
)

; commit action. 
; Adds new node to the tree
; Moves the 'is_active' to the new node
; Moves the branch pointer of the active branch to the new node
(:action commit
    :parameters (?n_h ?n_star - node ?h - hanch)
    :precondition (
      and
        (not (is_in_graph ?n_star))
        (is_head ?h)
        (b_points_to ?h ?n_h )
        (cur_obj ?n_star)
        ; === STATE ===
        (not(mode_rebase))
    )
    
    :effect (
      and
        (is_in_graph ?n_star)
        (n_is_parent ?n_h ?n_star)
        (b_points_to ?h ?n_star )
        (not (b_points_to ?h ?n_h ))
        (not (cur_obj ?n_star))
        (forall (?n - node) (when (next_obj ?n_star ?n) (cur_obj ?n)))
        (increase (total-cost) 1)
    )
)

(:action commit-no-branch
    :parameters (?n_h ?n_star - node)
    :precondition (
      and 
        (not (is_in_graph ?n_star))
        (is_head ?n_h)
        (cur_obj ?n_star)
        ; === STATE ===
        (not(mode_rebase))
    )
    :effect (
      and
        (is_in_graph ?n_star)
        (n_is_parent ?n_h ?n_star)
        (is_head ?n_star)
        (not (is_head ?n_h))
        (not (cur_obj ?n_star))
        (forall (?n - node) (when (next_obj ?n_star ?n) (cur_obj ?n)))
        (increase (total-cost) 1)
    )
)


; branch action.
; assigns a new branch label to current node
(:action branch
    :parameters (?n - node ?b_star - branch)
    :precondition (
      and 
        (not (is_in_graph ?b_star))
        (cur_obj ?b_star)
        ; === STATE ===
        (not(mode_rebase))
    )
    :effect (
      and 
        (is_in_graph ?b_star) 
        (b_points_to ?b_star ?n) 
        (not (cur_obj ?b_star))
        (forall (?b - branch) (when (next_obj ?b_star ?b) (cur_obj ?b)))
        (increase (total-cost) 1)
    )
)

; checkout action
(:action checkout
    :parameters (?h ?x - graphobj)
    :precondition (
      and 
        (is_head ?h)
        (is_in_graph ?x)
        ; === STATE ===
        (not(mode_rebase))
    )
    :effect (
      and
        (not (is_head ?h))
        (is_head ?x)
        (increase (total-cost) 1)
    )
)


(:action merge
    :parameters (?n_h ?y_b ?n_star - node ?y ?h - branch)
    :precondition (
      and
        (n_is_head ?n_h) ; active node
        (not (is_in_graph ?n_star)) ; new node is not used yet
        (b_points_to ?h ?n_h ) ; 
        (not (n_is_ancestor ?y_b ?n_h)) ; no merge required
        (not (n_is_ancestor ?n_h ?y_b)) ; no merge required
        (not (= ?n_h ?y_b)) ; make sure other and active are not the same
        (cur_obj ?n_star)
        ; === STATE ===
        (not(mode_rebase))
    )
    :effect (
      and
        (is_in_graph ?n_star)
        (n_is_parent ?n_h ?n_star)
        (n_is_parent ?y_b ?n_star)
        (b_points_to ?h ?n_star)
        (not (b_points_to ?h ?n_h))
        (not (cur_obj ?n_star))
        (forall (?n - node) (when (next_obj ?n_star ?n) (cur_obj ?n)))
        (increase (total-cost) 1)
    )
)

(:action merge-ancestor
    :parameters (?n_h ?y_b - node ?y ?h - branch)
    :precondition (
      and 
        (is_head ?h)
        (b_points_to ?h ?n_h)
        (not (= ?n_h ?y))
        (n_is_ancestor ?n_h ?y)
        ; === STATE ===
        (not(mode_rebase))
    )
    :effect (
      and 
        (b_points_to ?h ?y)
        (not (b_points_to ?h ?n_h))
        (increase (total-cost) 1)
    )
)


(:action rebase
    :parameters (?n_h ?n_d ?n_lca - node)
    :precondition (
      and  
        (n_is_head ?n_h)
        (n_is_first_common_ancestor ?n_lca ?n_h ?n_d) 
        (not (n_is_ancestor ?n_h ?n_d))
        (not (n_is_ancestor ?n_d ?n_h))
        ; === STATE ===
        (not(mode_rebase))
    )
    :effect (
      and 
        (mode_rebase)
        (rebase_state ?n_h ?n_d)
        (forall (?n - node) 
          (when 
            (and 
              (n_is_parent ?n_lca ?n)
              (not (rebase_is_copied ?n))
              (or 
                (n_is_ancestor ?n ?n_h)
                (= ?n ?n_h)
              )
            ) 
            (rebase_to_copy ?n))
        )
        (increase (total-cost) 1)
    )
)

(:action rebase__copy
    :parameters (?n_h ?n_target ?n_next ?n_star - node)
    :precondition (
      and
        (mode_rebase)
        (rebase_state ?n_h ?n_target)
        (rebase_to_copy ?n_next)
        (not (is_in_graph ?n_star))
        (cur_obj ?n_star)
    )
    :effect (
      and 
        ; Update rebase state
        (not (rebase_state ?n_h ?n_target))
        (rebase_state ?n_h ?n_star)
        ; insert n_star and mark n_next as copied
        (rebase_is_copied ?n_next)
        (n_is_copy_of ?n_star ?n_next)
        (is_in_graph ?n_star)
        (n_is_parent ?n_target ?n_star)
        ; Add all nodes that are children of n_next to the to_copy list
        (not (rebase_to_copy ?n_next))
        (forall (?n - node) 
          (when 
            (and 
              (n_is_parent ?n_next ?n)
              (not (rebase_is_copied ?n))
              (or 
                (n_is_ancestor ?n ?n_h)
                (= ?n ?n_h)
              )
            ) 
            (rebase_to_copy ?n))
        )
        (not (cur_obj ?n_star))
        (forall (?n - node) (when (next_obj ?n_star ?n) (cur_obj ?n)))
    )
)

(:action rebase__end
    :parameters (?n_h ?n_lc - node ?h - branch)
    :precondition (
      and 
        (mode_rebase)
        (rebase_state ?n_h ?n_lc)
        (is_head ?h)
        (not (exists (?n - node) 
          (rebase_to_copy ?n))
        )
    )
    :effect (
      and 
        (not (mode_rebase)) ; reset mode flag
        (not (rebase_state ?n_h ?n_lc)) ; reset state
        (forall (?n - node) (not (rebase_is_copied ?n))) ; reset copied flags
        ; no need to reset to_copy list
        (not (b_points_to ?h ?n_h))
        (b_points_to ?h ?n_lc)
    )
)


)