(define (domain no_derived_ordered)

(:requirements :strips :typing :negative-preconditions :equality :disjunctive-preconditions :derived-predicates :conditional-effects :action-costs)

(:types
  graphobj - object
  node branch - graphobj
)

(:predicates
  (n_is_parent ?n_parent ?n_child - node)
  (n_is_ancestor ?ancestor ?base - node)
  (b_points_to ?b - branch ?n - node)
  (n_is_copy_of ?n1 ?n2 - node)
  (is_in_graph ?bn - graphobj)
  (is_head ?bn - graphobj) ; node or branch can be HEAD
  
  (next_obj ?o1 ?o2)
  (cur_obj ?o)
  
  ; === STATE ===
  (mode_rebase)
  (rebase_state ?head ?target)
  (rebase_to_copy ?n )
  (rebase_is_copied ?n - node) 
)

(:functions
  (total-cost)
)


; commit action. 
; Adds new node to the tree
; Moves the 'is_active' to the new node
; Moves the branch pointer of the active branch to the new node
(:action commit
    :parameters (?n_head ?n_free - node ?br - branch)
    :precondition (
      and
        (not (is_in_graph ?n_free))
        (is_head ?br)
        (b_points_to ?br ?n_head )
        (cur_obj ?n_free)
        ; === STATE ===
        (not(mode_rebase))
    )
    
    :effect (
      and
        (is_in_graph ?n_free)
        (n_is_parent ?n_head ?n_free)
        (n_is_ancestor ?n_head ?n_free)
        (forall (?ancestor - node) ; make all ancestors of n_head also of n_free
          (when (n_is_ancestor ?ancestor ?n_head)
            (n_is_ancestor ?ancestor ?n_free)  
          )
        )
        (b_points_to ?br ?n_free )
        (not (b_points_to ?br ?n_head ))
        (not (cur_obj ?n_free))
        (forall (?n - node) (when (next_obj ?n_free ?n) (cur_obj ?n)))
        (increase (total-cost) 1)
    )
)

(:action commit-no-branch
    :parameters (?n_head ?n_free - node)
    :precondition (
      and 
        (not (is_in_graph ?n_free))
        (is_head ?n_head)
        (cur_obj ?n_free)
        ; === STATE ===
        (not(mode_rebase))
    )
    :effect (
      and
        (is_in_graph ?n_free)
        (n_is_parent ?n_head ?n_free)
        (n_is_ancestor ?n_head ?n_free)
        (forall (?ancestor - node) ; make all ancestors of n_head also of n_free
          (when (n_is_ancestor ?ancestor ?n_head)
            (n_is_ancestor ?ancestor ?n_free)  
          )
        )
        (is_head ?n_free)
        (not (is_head ?n_head))
        (not (cur_obj ?n_free))
        (forall (?n - node) (when (next_obj ?n_free ?n) (cur_obj ?n)))
        (increase (total-cost) 1)
    )
)


; branch action.
; assigns a new branch label to current node
(:action branch
    :parameters (?n - node ?br - branch)
    :precondition (
      and 
        (not (is_in_graph ?br))
        (cur_obj ?br)
        ; === STATE ===
        (not(mode_rebase))
    )
    :effect (
      and 
        (is_in_graph ?br) 
        (b_points_to ?br ?n) 
        (not (cur_obj ?br))
        (forall (?b - branch) (when (next_obj ?br ?b) (cur_obj ?b)))
        (increase (total-cost) 1)
    )
)

; checkout action
(:action checkout
    :parameters (?bn_old ?bn_new - graphobj)
    :precondition (
      and 
        (is_head ?bn_old)
        (is_in_graph ?bn_new)
        ; === STATE ===
        (not(mode_rebase))
    )
    :effect (
      and
        (not (is_head ?bn_old))
        (is_head ?bn_new)
        (increase (total-cost) 1)
    )
)


(:action merge
    :parameters (?n_head ?n_other ?n_new - node ?b_head - branch)
    :precondition (
      and
        (or
          (is_head ?n_head)
          (is_head ?b_head)
        )
        (not (is_in_graph ?n_new)) ; new node is not used yet
        (b_points_to ?b_head ?n_head ) ; 
        (not (n_is_ancestor ?n_other ?n_head)) ; no merge required
        (not (n_is_ancestor ?n_head ?n_other)) ; no merge required
        (not (= ?n_head ?n_other)) ; make sure other and active are not the same
        (cur_obj ?n_new)
        ; === STATE ===
        (not(mode_rebase))
    )
    :effect (
      and
        (is_in_graph ?n_new)
        (n_is_parent ?n_head ?n_new)
        (n_is_parent ?n_other ?n_new)
        (n_is_ancestor ?n_head ?n_new)
        (n_is_ancestor ?n_other ?n_new)
        (forall (?ancestor - node) ; make all ancestors of n_head and n_other also ancestors of n_free
          (and
            (when (n_is_ancestor ?ancestor ?n_head)
              (n_is_ancestor ?ancestor ?n_new)  
            )
            (when (n_is_ancestor ?ancestor ?n_other)
              (n_is_ancestor ?ancestor ?n_new)
            )
          )
        )
        (b_points_to ?b_head ?n_new)
        (not (b_points_to ?b_head ?n_head))
        (not (cur_obj ?n_new))
        (forall (?n - node) (when (next_obj ?n_new ?n) (cur_obj ?n)))
        (increase (total-cost) 1)
    )
)

(:action merge-ancestor
    :parameters (?n_h ?y - node ?h - branch)
    :precondition (
      and 
        (is_head ?h)
        (b_points_to ?h ?n_h)
        (not (= ?n_h ?y))
        (n_is_ancestor ?n_h ?y)
        ; === STATE ===
        (not(mode_rebase))
    )
    :effect (
      and 
        (b_points_to ?h ?y)
        (not (b_points_to ?h ?n_h))
        (increase (total-cost) 1)
    )
)


(:action rebase
    :parameters (?n_head ?n_other ?n_common_ancestor ?n_next - node)
    :precondition (
      and  
        ; n_head is head node
        (exists (?b - branch) 
          (and 
            (is_head ?b)
            (b_points_to ?b ?n_head)
          )
        )
        ;;;;; FIRST COMMON ANCESTOR
        (n_is_ancestor ?n_common_ancestor ?n_head)
        (n_is_ancestor ?n_common_ancestor ?n_other)
        (not (= ?n_head ?n_other))
        (not (exists (?n_child - node) 
          (and
            (n_is_parent ?n_common_ancestor ?n_child)
            (n_is_ancestor ?n_child ?n_head)
            (n_is_ancestor ?n_child ?n_other)
          )
        ))
        ;;;;;
        (not (n_is_ancestor ?n_head ?n_other)) 
        (not (n_is_ancestor ?n_other ?n_head))
        ; find correct n_next
        (n_is_parent ?n_common_ancestor ?n_next)
        (or
          (n_is_ancestor ?n_next ?n_head)
          (= ?n_next ?n_head)
        )
        ; === STATE ===
        (not(mode_rebase))
    )
    :effect (
      and 
        (mode_rebase)
        (rebase_state ?n_head ?n_other)
        (rebase_to_copy ?n_next)
        (increase (total-cost) 1)
    )
)

(:action rebase__copy
    :parameters (?n_head ?n_target ?n_next ?n_new - node)
    :precondition (
      and
        (mode_rebase)
        (rebase_state ?n_head ?n_target)
        (rebase_to_copy ?n_next)
        (not (is_in_graph ?n_new))
        (cur_obj ?n_new)
    )
    :effect (
      and
        (not (rebase_state ?n_head ?n_target))
        (rebase_state ?n_head ?n_new)
        (rebase_is_copied ?n_next)
        ; mark next_to_copy as copied
        (n_is_copy_of ?n_new ?n_next)
        (is_in_graph ?n_new)
        (n_is_parent ?n_target ?n_new)
        (n_is_ancestor ?n_target ?n_new)
        ; make all ancestors of n_target also of n_new
        (forall (?ancestor - node) 
          (when (n_is_ancestor ?ancestor ?n_target)
            (n_is_ancestor ?ancestor ?n_new)  
          )
        )
        ; Add all nodes that are children of n_next to the to_copy list
        (not (rebase_to_copy ?n_next))
        (forall (?n - node) 
          (when 
            (and 
              (n_is_parent ?n_next ?n)
              (not (rebase_is_copied ?n))
              (or 
                (n_is_ancestor ?n ?n_head)
                (= ?n ?n_head)
              )
            ) 
            (rebase_to_copy ?n))
        )
        (not (cur_obj ?n_new))
        (forall (?n - node) (when (next_obj ?n_new ?n) (cur_obj ?n)))
        ; no total cost increase
    )
)

(:action rebase__end
    :parameters (?n_head ?n_last_copied - node ?b_head - branch)
    :precondition (
      and 
        (mode_rebase)
        (rebase_state ?n_head ?n_last_copied)
        (is_head ?b_head)
        (not (exists (?n - node) 
          (rebase_to_copy ?n))
        )
    )
    :effect (
      and 
        (not (mode_rebase)) ; reset mode flag
        (not (rebase_state ?n_head ?n_last_copied)) ; reset state
        (forall (?n - node) (not (rebase_is_copied ?n))) ; reset copied flags
        ; no need to reset to_copy list
        (not (b_points_to ?b_head ?n_head))
        (b_points_to ?b_head ?n_last_copied)
        ; no total cost increase
    )
)




)