#! /usr/bin/env python

import os
import glob
import itertools
import json
import sys
import project

TESTSUITE_FILE = os.path.join(sys.path[0], 'testsuite-2021-01-03.json')

with open(TESTSUITE_FILE) as json_file:
    TESTSUITE = json.load(json_file)

# relative to git root
BENCHMARKS_DIR = '../model/'



SUITE = []
for suite in TESTSUITE['suites']:
    for filename in suite['files']:
        SUITE.append((suite['name'], filename.replace("/", ":")))

for f in SUITE:
    if 'domain.pddl' in f[1]:
        SUITE.remove(f)
        print("remove", f)

TIME_LIMIT='2m'
MEMORY_LIMIT='1000M'

if project.REMOTE:
    REPO = '../../downward-projects/downward/'
    ENV = project.BaselSlurmEnvironment(email="tim.bachmann@stud.unibas.ch")
    TIME_LIMIT='20m'
    MEMORY_LIMIT='3800M'
else:
    REPO = '../../downward-proj/downward/'
    ENV = project.LocalEnvironment(processes=2)


CONFIGS = [
    (f"{idx:02d}-{nick}", config, alias)
    for idx, (nick, config, alias) in enumerate([
        ("lama", [], ["--alias", "seq-sat-lama-2011"]),
        ("lama-first", [], ["--alias", "lama-first"]),
        ("astar-hmax", ["--search", "astar(hmax())"], []),
        ("astar-blind", ["--search", "astar(blind())"], []),
        ("astar-goalcount", ["--search", "astar(goalcount())"], []),
        ("eager-goalcount", ["--search", "eager_greedy([goalcount()])"], []),
        ("eager-blind", ["--search", "eager_greedy([blind()])"], []),
    ])
]



DRIVER_OPTIONS = [
    "--overall-time-limit", TIME_LIMIT,
    "--overall-memory-limit", MEMORY_LIMIT,
]
ATTRIBUTES = [
    "error",
    "run_dir",
    "search_start_time",
    "search_start_memory",
    "total_time",
    "initial_h_value",
    "h_values",
    "coverage",
    "expansions",
    "memory",
    "pddl_objects",
    "translator_axioms",
    "translator_axioms_removed",
    "translator_derived_variables",
    project.EVALUATIONS_PER_TIME,
]

exp = project.CommonExperiment(environment=ENV)
for config_nick, config, alias in CONFIGS:
    algo_name = f'{"20.06"}:{config_nick}'
    exp.add_algorithm(
        algo_name,
        REPO,
        "release-20.06.0",
        config,
        build_options=[],
        driver_options=DRIVER_OPTIONS + alias,
    )
exp.add_suites(BENCHMARKS_DIR, SUITE)

project.add_reports(exp, ATTRIBUTES)

exp.run_steps()
