#! /usr/bin/env python

import os
import glob
import itertools
import json
import sys
import project

TESTSUITE_FILE = os.path.join(sys.path[0], 'testsuite-2021-01-03.json')

with open(TESTSUITE_FILE) as json_file:
    TESTSUITE = json.load(json_file)

# relative to git root
BENCHMARKS_DIR = '../model/'



SUITE = []
for suite in TESTSUITE['suites']:
    for filename in suite['files']:
        SUITE.append((suite['name'], filename.replace("/", ":")))

for f in SUITE:
    if 'domain.pddl' in f[1]:
        SUITE.remove(f)
        print("remove", f)

TIME_LIMIT='2m'
MEMORY_LIMIT='1000M'

if project.REMOTE:
    REPO = '../../downward-projects/downward/'
    ENV = project.BaselSlurmEnvironment(email="tim.bachmann@stud.unibas.ch")
    TIME_LIMIT='20m'
    MEMORY_LIMIT='3800M'
else:
    REPO = '../../downward-proj/downward/'
    ENV = project.LocalEnvironment(processes=2)

CONFIGS = [
    (f"{index:02d}-{h_nick}", ["--search", f"eager_greedy([{h}])"])
    for index, (h_nick, h) in enumerate(
        [
            ("add", "add(transform=adapt_costs(one), cache_estimates=false)"),
            ("blind", "blind(transform=adapt_costs(one), cache_estimates=false)"),
            ("cea", "cea(transform=adapt_costs(one), cache_estimates=false)"),
            ("cg", "cg(transform=adapt_costs(one), cache_estimates=false)"),
            ("ff", "ff(transform=adapt_costs(one), cache_estimates=false)"),
            ("goalcount", "goalcount(transform=adapt_costs(one), cache_estimates=false)"),
            ("hm", "hm(m=2, transform=adapt_costs(one), cache_estimates=false)"),
            ("hmax", "hmax(transform=adapt_costs(one), cache_estimates=false)"),
            #("lmcut", "lmcut()") doesn't support axioms
        ],
        start=1,
    )
]

BUILD_OPTIONS = []
DRIVER_OPTIONS = [
    "--overall-time-limit", TIME_LIMIT,
    "--overall-memory-limit", MEMORY_LIMIT,
]
FD_REV = ("release-20.06.0", "20.06")

ATTRIBUTES = [
    "error",
    "run_dir",
    "search_start_time",
    "search_start_memory",
    "total_time",
    "initial_h_value",
    "h_values",
    "coverage",
    "expansions",
    "memory",
    "pddl_objects",
    project.EVALUATIONS_PER_TIME,
]

exp = project.CommonExperiment(environment=ENV)
for config_nick, config in CONFIGS:
    rev, rev_nick = FD_REV
    algo_name = f"{rev_nick}:{config_nick}" if rev_nick else config_nick
    exp.add_algorithm(
        algo_name,
        REPO,
        rev,
        config,
        build_options=BUILD_OPTIONS,
        driver_options=DRIVER_OPTIONS,
    )
exp.add_suites(BENCHMARKS_DIR, SUITE)

project.add_reports(exp, ATTRIBUTES)

exp.run_steps()
