#! /usr/bin/env python

import os
import glob
import itertools

import project

# relative to git root
BENCHMARKS_DIR = 'model/'
# revision, "folder,problem_file"


REVS = ["master", "no-axioms"]
FILES = list(map(
    lambda x: f'default:{os.path.split(x)[1]}'
    ,glob.glob(os.path.join('..',BENCHMARKS_DIR, 'default', '*.pddl'))))

for f in list(FILES):
    if 'domain.pddl' in f:
        FILES.remove(f)

SUITE = list(itertools.product(REVS, FILES))

TIME_LIMIT='2m'
MEMORY_LIMIT='1000M'

if project.REMOTE:
    REPO = '../../downward-projects/downward/'
    ENV = project.BaselSlurmEnvironment(email="tim.bachmann@stud.unibas.ch")
    TIME_LIMIT='20m'
    MEMORY_LIMIT='3800M'
else:
    REPO = '../../downward-proj/downward/'
    ENV = project.LocalEnvironment(processes=2)

CONFIGS = [
    (f"{index:02d}-{h_nick}", ["--search", f"eager_greedy([{h}])"])
    for index, (h_nick, h) in enumerate(
        [
            ("cg", "cg(transform=adapt_costs(one))"),
            #("ff", "ff(transform=adapt_costs(one))"),
            #("hm", "hm(m=2, transform=no_transform(), cache_estimates=false)"),
            #("hm", "hm(m=2, transform=no_transform(), cache_estimates=true)"),
        ],
        start=1,
    )
]

BUILD_OPTIONS = []
DRIVER_OPTIONS = [
    "--overall-time-limit", TIME_LIMIT,
    "--overall-memory-limit", MEMORY_LIMIT,
]
FD_REV = ("release-20.06.0", "20.06")

ATTRIBUTES = [
    "error",
    "run_dir",
    "search_start_time",
    "search_start_memory",
    "total_time",
    "initial_h_value",
    "h_values",
    "coverage",
    "expansions",
    "memory",
    project.EVALUATIONS_PER_TIME,
]

exp = project.CommonExperiment(environment=ENV)
for config_nick, config in CONFIGS:
    rev, rev_nick = FD_REV
    algo_name = f"{rev_nick}:{config_nick}" if rev_nick else config_nick
    exp.add_algorithm(
        algo_name,
        REPO,
        rev,
        config,
        build_options=BUILD_OPTIONS,
        driver_options=DRIVER_OPTIONS,
    )
exp.add_suite_revision(BENCHMARKS_DIR, SUITE)

project.add_reports(exp, ATTRIBUTES)

exp.run_steps()
