#!/usr/bin/env bash

#eval "$(conda shell.bash hook)"
#conda activate thesis

#export PATH=/home/tim/unibas/bachelorthesis/INVAL:$PATH

PROBLEM=${1:-prob1}
DOMAIN=domain
FOLDER=model/${2:-default}
SRC_DIR=output/$PROBLEM-pddl

LOGFILE=$SRC_DIR/$PROBLEM.log

if test -f "./$SRC_DIR/$PROBLEM.plan"; then
    PLAN=./$SRC_DIR/$PROBLEM.plan
else
    echo "plan file not found $SRC_DIR/$PROBLEM.plan"
    exit
fi


inval ./$FOLDER/$DOMAIN.pddl ./$FOLDER/$PROBLEM.pddl $PLAN > $LOGFILE

cat $LOGFILE
cat $LOGFILE | python scripts/render_graph.py --name $PROBLEM --join
python scripts/render_graph.py --name $PROBLEM-pddl --type pddl --input ./$FOLDER/$PROBLEM.pddl --join