#pragma once
#include "landmark_factory.h"

namespace landmarks
{

    class LandmarkFactoryMiconic : public LandmarkFactory
    {
    public:
        explicit LandmarkFactoryMiconic(const options::Options &opts);
        virtual bool supports_conditional_effects() const override;
        bool initialized = false;
        std::unordered_map<std::string, FactPair> lookupMap;
        virtual void generate_landmarks(const std::shared_ptr<AbstractTask> &task) override;
        void generate_miconic_graph(TaskProxy &taskProxy);
        void calc_achievers(const TaskProxy &taskProxy);
    };
}