#include "landmark_factory_miconic.h"
#include "../utils/logging.h"
#include "landmark_graph.h"
#include "../plugin.h"
#include "../option_parser.h"


namespace landmarks
{

    LandmarkFactoryMiconic::LandmarkFactoryMiconic(const options::Options &opts)
        : LandmarkFactory(opts)
    {
    }

    void LandmarkFactoryMiconic::generate_landmarks(const std::shared_ptr<AbstractTask> &task)
    {
        TaskProxy taskProxy(*task);

        if (!initialized)
        {
            initialized = true;
            for (FactProxy facts : taskProxy.get_variables().get_facts())
            {
                lookupMap.emplace(facts.get_name(), facts.get_pair());
            }
        }

        generate_miconic_graph(taskProxy); 
    }

    bool LandmarkFactoryMiconic::supports_conditional_effects() const
    {
        return true;
    }

    void LandmarkFactoryMiconic::generate_miconic_graph(TaskProxy &taskProxy)
    {

        State currentState = taskProxy.get_initial_state();

        for (FactProxy goal : taskProxy.get_goals())
        {
            if (currentState[goal.get_variable()].get_value() != goal.get_value())
            {
                LandmarkNode &lmNode = lm_graph->add_simple_landmark(goal.get_pair());
                lmNode.is_true_in_goal = true;
            }
        }
        for(FactProxy fact : currentState){
            utils::g_log << fact.get_name() << std::endl;
        }
        for(auto x : lookupMap){
            utils::g_log << x.first << " is the name " << x.second.var << " is the value." << std::endl; 

        }

        lm_graph -> set_landmark_ids();


    }
    
    static std::shared_ptr<LandmarkFactory> _parse(OptionParser &parser)
    {
        parser.document_synopsis(
            "MIconic Landmarks",
            "Only for miconic task checks for each fact if it is a landmark."
            "This check is for Miconic Task");
        parser.document_note(
            "No relevant options right now",
            "reasonable_ordersddddddddddd");
        _add_options_to_parser(parser);

        Options opts = parser.parse();

        if (parser.dry_run())
            return nullptr;
        else
            return std::make_shared<LandmarkFactoryMiconic>(opts);
    }
    static Plugin<LandmarkFactory> _plugin("lm_miconic", _parse);
}