#ifndef CYCLIC_LANDMARKS_LANDMARK_CONSTRAINT_HANDLER_H
#define CYCLIC_LANDMARKS_LANDMARK_CONSTRAINT_HANDLER_H

#include "../option_parser.h"
#include "../task_proxy.h"

namespace landmarks {
class DisjActionLandmarkGraph;
class LandmarkFactory;
class LandmarkGraph;
class LandmarkFactoryLogistics;
class LandmarkConstraintHandler {
    LandmarkConstraintHandler() = default;
    ~LandmarkConstraintHandler() = default;

    long num_landmarks = 0;
    long num_orderings = 0;
    long num_weak_orderings = 0;
    int num_lm_graphs = 0;

    bool initialized = false;
    std::shared_ptr<LandmarkFactory> lm;
    std::shared_ptr<AbstractTask> task;
    std::shared_ptr<TaskProxy> task_proxy;

    std::shared_ptr<DisjActionLandmarkGraph> dalm_graph;
    StateID last_state_id = StateID::no_state;

    void compute_lm_graph(const State &state);
public:
    static long num_cycles;

    static LandmarkConstraintHandler &get_instance();
    void initialize(const options::Options &opts,
                    const std::shared_ptr<AbstractTask> &task);
    std::shared_ptr<DisjActionLandmarkGraph> get_lm_graph(const State &state);

    void print_statistics() const;
};
}

#endif
