(define (domain logistics)
  (:requirements :strips)
  (:predicates (OBJ ?obj)
               (TRUCK ?truck)
               (CITY ?city)
               (at ?obj ?city)
               (in ?obj1 ?obj2))

(:action LOAD
  :parameters (?obj ?truck ?city)
  :precondition (and (OBJ ?obj)
                     (TRUCK ?truck)
                     (CITY ?city)
                     (at ?truck ?city)
                     (at ?obj ?city))
  :effect (and (not (at ?obj ?city))
               (in ?obj ?truck)))

(:action UNLOAD
  :parameters (?obj ?truck ?city)
  :precondition (and (OBJ ?obj)
                     (TRUCK ?truck)
                     (CITY ?city)
                     (at ?truck ?city)
                     (in ?obj ?truck))
  :effect (and (not (in ?obj ?truck))
               (at ?obj ?city)))

(:action MOVE
  :parameters (?truck ?city-from ?city-to)
  :precondition (and (TRUCK ?truck)
                     (CITY ?city-from)
                     (CITY ?city-to)
                     (at ?truck ?city-from))
  :effect (and (not (at ?truck ?city-from))
               (at ?truck ?city-to)))
)
