#! /usr/bin/env python
# -*- coding: utf-8 -*-

import common_setup

import os

from lab.environments import LocalEnvironment, BaselSlurmEnvironment

REVISIONS = [
    "8951559",
]

CONFIGS = [
    common_setup.IssueConfig("cycle", ["--search","astar(cycle(lm=lm_logistics(reasonable_orders=true,conjunctive_landmarks=false), lpsolver=CPLEX, use_integer_operator_counts=false, cycle_generator=floyd_warshall, strong=true))"],),
        common_setup.IssueConfig("cycleIntegrated", ["--search","astar(cycle(lm=lm_logistics(reasonable_orders=true,conjunctive_landmarks=false, integrated=true), lpsolver=CPLEX, use_integer_operator_counts=false, cycle_generator=floyd_warshall, strong=true))"],),
            common_setup.IssueConfig("rhw", ["--search","astar(cycle(lm=lm_rhw(reasonable_orders=true,conjunctive_landmarks=false), lpsolver=CPLEX, use_integer_operator_counts=false, cycle_generator=floyd_warshall, strong=true))"],)
        
    
]

BENCHMARKS_DIR = os.environ["DOWNWARD_BENCHMARKS"]
REPO = os.environ["DOWNWARD_REPO"]

if common_setup.is_running_on_cluster():
    SUITE = ["logistics00", "more-logistics-benchmarks"]
    ENVIRONMENT = BaselSlurmEnvironment(
        partition="infai_2",
        email="guenes.aydin@unibas.ch",
        export=["PATH", "DOWNWARD_BENCHMARKS"],
        setup='export PATH=/scicore/soft/apps/binutils/2.32-GCCcore-8.3.0/bin:/scicore/soft/apps/CMake/3.15.3-GCCcore-8.3.0/bin:/scicore/soft/apps/cURL/7.66.0-GCCcore-8.3.0/bin:/scicore/soft/apps/bzip2/1.0.8-GCCcore-8.3.0/bin:/scicore/soft/apps/ncurses/6.1-GCCcore-8.3.0/bin:/scicore/soft/apps/GCCcore/8.3.0/bin:/infai/sieverss/repos/bin:/infai/sieverss/local:/export/soft/lua_lmod/centos7/lmod/lmod/libexec:/usr/local/bin:/usr/bin:/usr/local/sbin:/usr/sbin:$PATH\nexport LD_LIBRARY_PATH=/scicore/soft/apps/binutils/2.32-GCCcore-8.3.0/lib:/scicore/soft/apps/cURL/7.66.0-GCCcore-8.3.0/lib:/scicore/soft/apps/bzip2/1.0.8-GCCcore-8.3.0/lib:/scicore/soft/apps/zlib/1.2.11-GCCcore-8.3.0/lib:/scicore/soft/apps/ncurses/6.1-GCCcore-8.3.0/lib:/scicore/soft/apps/GCCcore/8.3.0/lib64:/scicore/soft/apps/GCCcore/8.3.0/lib'
    )
else:
    SUITE =["logistics00:probLOGISTICS-4-2.pddl","logistics00:probLOGISTICS-10-0.pddl"]
    ENVIRONMENT = LocalEnvironment(processes=2)

exp = common_setup.IssueExperiment(
    revisions=REVISIONS,
    configs=CONFIGS,
    environment=ENVIRONMENT,
)

exp.add_suite(BENCHMARKS_DIR, SUITE)

exp.add_parser(exp.EXITCODE_PARSER)
exp.add_parser(exp.PLANNER_PARSER)
exp.add_parser(exp.SINGLE_SEARCH_PARSER)

exp.add_step("build", exp.build)
exp.add_step("start", exp.start_runs)
exp.add_fetcher(name="fetch")
exp.add_absolute_report_step()
exp.add_comparison_table_step()
exp.add_parse_again_step()


exp.run_steps()

