#! /usr/bin/env python
# -*- coding: utf-8 -*-

import os
from downward.reports.absolute import AbsoluteReport
from lab.experiment import Experiment
from downward.reports.scatter import ScatterPlotReport

EXPERIMENT_DIRS = [
  "logistics2-v1-optimal-98-eval",
  "logistics2-v1-optimal-logistics98-eval",
]
ATTRIBUTES = [
    "cost",
    "coverage",
    "error",
    "evaluations",
    "expansions",
    "expansions_until_last_jump",
    "initial_h_value",
    "generated",
    "memory",
    "planner_memory",
    "planner_time",
    "quality",
    "run_dir",
    "score_evaluations",
    "score_expansions",
    "score_generated",
    "score_memory",
    "score_search_time",
    "score_total_time",
    "search_time",
    "total_time",
]

exp_name = "combine"
exp_dir_name = f"data/{exp_name}"
os.makedirs(f"{exp_dir_name}-eval", exist_ok=True)

first = True
exp = Experiment(exp_dir_name)
for exp_dir in EXPERIMENT_DIRS:
  exp.add_fetcher(src="/infai/cimaro42/downward-cyclic-landmarks/experiments/logistics2/data/" + f"{exp_dir}", merge=not first)
  first=False

report = AbsoluteReport(attributes=ATTRIBUTES, filter=[]) ## Remove the filter argument if you don't want to use filters (see https://lab.readthedocs.io/en/stable/lab.reports.html for examples). 
outfile = os.path.join(exp.eval_dir, f"{os.path.basename(__file__)[:-3]}-combine")

exp.add_report(report, outfile)
exp.add_report(ScatterPlotReport(
attributes=["expansions_until_last_jump"],
filter_algorithm=["64d53f-cycle", "64d53f-cycleIntegrated"],
format="png",
),
name="expansion_last_jump"
)
exp.add_report(ScatterPlotReport(
attributes=["expansions_until_last_jump"],
filter_algorithm=["b98e9c8-rhw", "64d53f-cycleIntegrated"],
format="png",
),
name="expansion_last_jump_rhwVSintegrated"
)
exp.add_report(ScatterPlotReport(
attributes=["initial_h_value"],
filter_algorithm=["b98e9c8-rhw", "64d53f-cycleIntegrated"],
format="png",
),
name="initial_heuristic_rhwVSintegrated"
)
exp.add_report(ScatterPlotReport(
attributes=["initial_h_value"],
filter_algorithm=["64d53f-cycle", "64d53f-cycleIntegrated"],
format="png",
),
name="initial_h_value"
)

exp.add_report(ScatterPlotReport(
attributes=["memory"],
filter_algorithm=["64d53f-cycle", "64d53f-cycleIntegrated"],
format="png",
),
name="memory"
)

exp.add_report(ScatterPlotReport(
attributes=["memory"],
filter_algorithm=["b98e9c8-rhw", "64d53f-cycleIntegrated"],
format="png",
),
name="memory_rhwVSintegrated"
)

exp.add_report(ScatterPlotReport(
attributes=["total_time"],
filter_algorithm=["64d53f-cycle", "64d53f-cycleIntegrated"],
format="png",
),
name="total_time"
)

exp.add_report(ScatterPlotReport(
attributes=["total_time"],
filter_algorithm=["b98e9c8-rhw", "64d53f-cycleIntegrated"],
format="png",
),
name="total_time_rhwVSintegrated"
)

exp.run_steps()
