#! /usr/bin/env python

import os

import project


REPO = project.get_repo_base()
BENCHMARKS_DIR = os.environ["DOWNWARD_BENCHMARKS"]
if project.REMOTE:
    SUITE = project.SUITE_SATISFICING
    ENV = project.BaselSlurmEnvironment(email="guenes.aydin@unibas.ch")
else:
    SUITE = ["logistics00:probLOGISTICS-4-0.pddl", "logistics00:probLOGISTICS-4-1.pddl"]
    ENV = project.LocalEnvironment(processes=2)

CONFIGS = [
    (f"{index:02d}-{h_nick}", ["--search", f"astar([{h}])"])
    for index, (h_nick, h) in enumerate(
        [
            ("cycle", "cycle(lm=lm_logistics(reasonable_orders=true,conjunctive_landmarks=false), lpsolver=CPLEX, use_integer_operator_counts=false, cycle_generator=floyd_warshall, strong=true)"
)
              ],
        start=1,
    )
]
BUILD_OPTIONS = []
DRIVER_OPTIONS = ["--overall-time-limit", "30m"]
REVS = [
    ("a9a927a3e"),
]
ATTRIBUTES = [
    "error",
    "run_dir",
    "total_time",
    "initial_h_value",
    "coverage",
    "expansions",
    "memory",
    project.EVALUATIONS_PER_TIME,
]

exp = project.CommonExperiment(environment=ENV)
for config_nick, config in CONFIGS:
    for rev, rev_nick in REVS:
        algo_name = f"{rev_nick}:{config_nick}" if rev_nick else config_nick
        exp.add_algorithm(
            algo_name,
            REPO,
            rev,
            config,
            build_options=BUILD_OPTIONS,
            driver_options=DRIVER_OPTIONS,
        )
exp.add_suite(BENCHMARKS_DIR, SUITE)

project.add_absolute_report(
    exp, attributes=ATTRIBUTES, filter=[project.add_evaluations_per_time]
)

exp.run_steps()

