#include "my_heuristic.h"

#include "../global_state.h"
#include "../option_parser.h"
#include "../plugin.h"

#include "../task_utils/task_properties.h"

using namespace std;

namespace my_heuristic {
MyHeuristic::MyHeuristic(const Options &opts)
    : Heuristic(opts),
      max_value(opts.get<int>("max_value")) {
}

int MyHeuristic::compute_heuristic(const GlobalState &global_state) {
    State state = convert_global_state(global_state);
    int unsatisfied_goal_count = 0;

    for (FactProxy goal : task_proxy.get_goals()) {
        const VariableProxy var = goal.get_variable();
        if (state[var] != goal) {
            ++unsatisfied_goal_count;
            if (unsatisfied_goal_count == max_value) {
                break;
            }
        }
    }
    return unsatisfied_goal_count;
}

static shared_ptr<Heuristic> _parse(OptionParser &parser) {
    Heuristic::add_options_to_parser(parser);
    parser.add_option<int>(
        "max_value",
        "Maximal heuristic value (just to show how to add a parameter)",
        "infinity",
        Bounds("1", "infinity"));
    Options opts = parser.parse();
    if (parser.dry_run())
        return nullptr;
    else
        return make_shared<MyHeuristic>(opts);
}

static Plugin<Evaluator> _plugin("my_heuristic", _parse);
}
