import java.util.ArrayList;

public class TreeNode {
  private String name;
  private TreeNode parent;
  private ArrayList<TreeNode> children;
  
  
  TreeNode(String name, TreeNode parent) {
    this.name = name;
    this.parent = parent;
    children = new ArrayList<TreeNode>();
  }
  
  public String getName() {
    return name;
  }
  
  public ArrayList<TreeNode> getChildern() {
    return children;
  }
  
  public TreeNode getParent() {
    return parent;
  }
  
  
  public TreeNode addChild(String name) {
    TreeNode child = new TreeNode(name, this);
    children.add(child);
    return child;
  }  

  public void print(String indent) {
    System.out.println(indent + name);
    for (TreeNode child : children) {
      child.print(indent + "  ");
    }
  }
  
  public Integer getHeight() {
    Integer maxChildHeight = -1;
    for (TreeNode child : children) {
      maxChildHeight = Math.max(maxChildHeight, child.getHeight());
    }
    return maxChildHeight + 1;
  }
}
