package logic.proofs.rules;

import logic.formulas.Formula;

/**
 * Container class for an inference rule.
 */
public class InferenceRule {
    /** Name of the rule (used in proof files for parsing, and the output) */
    private String name;
    /** Left hand side of the rule. */
    private Formula[] conditions;
    /** right hand side of the rule */
    private Formula result;

    public InferenceRule(String name, Formula[] conditions, Formula result) {
        this.name = name;
        this.conditions = conditions;
        this.result = result;
    }

    public String getName() {
        return name;
    }

    public Formula[] getConditions() {
        return conditions;
    }

    public Formula getResult() {
        return result;
    }
}
