package logic.proofs;

import logic.formulas.Formula;
import logic.proofs.rules.InferenceRule;

/**
 * Container class for one proof step.
 */
public class ProofStep {
    /** The formula this step should prove. */
    private Formula formula;
    /** The rule used to prove the formula. If rule is null, the formula is an assumption. */
    private InferenceRule rule;
    /** The formulas uses as inputs for the rule. */
    private Formula[] ruleInputs;

    public ProofStep(Formula formula, InferenceRule rule, Formula[] ruleInputs) {
        this.formula = formula;
        this.rule = rule;
        this.ruleInputs = ruleInputs;
    }

    public Formula getFormula() {
        return formula;
    }

    public InferenceRule getRule() {
        return rule;
    }

    public Formula[] getRuleInputs() {
        return ruleInputs;
    }
}
