import numpy as np
import pygame
from pygame import *
from pygame.locals import *
from math import *
import os
import subprocess

# To run this problem, go into the folder this script is located in and open a terminal.
# In that terminal:
# python3 main.py

# Sets spawn of head, tail and first spawn of food in the grid.
# At first I considered looking at all foods and displaying them in order of spawn.
# This did not make sense, after inspecting the sas-file, 
# that looks to spawn foods at its own pace.
# We parse the file and look for certain patterns in the lines to identify what the line means to do.
# After that the necessary data is extracted.
def initialize():
	#print(grid)
	last_spawn = ()

	while True:
		line = p01.readline().strip()
		
		if not line:
			break

		if line[1:5] == "tail":
			tail = line.split()[1][3:6]
			#print("TAIL: " + tail)
			last_x = int(tail[0:1])
			last_y = int(tail[2])
			#print(position_x, position_y)
			grid[last_x][last_y] = 1

		elif line[1:5] == "head":
			head = line.split()[1][3:6]
			#print("HEAD: " + head)
			position_x = int(head[0:1])
			position_y = int(head[2])
			#print(position_x, position_y)
			grid[position_x][position_y] = snake_length
			snake_x = position_x
			snake_y = position_y

		elif line[1:6] == "spawn":
			spawn = line.split()[1][3:6]
			#print("SPAWN: " + spawn)
			position_x = int(spawn[0:1])
			position_y = int(spawn[2])
			first_spawn = (position_x, position_y)
			#print(first_spawn)
			grid[position_x][position_y] = -1

	return (snake_x-last_x, snake_y-last_y)

			#This looks for a dummy (as this would be the last spawn)
		# elif line[1:10] == "NEXTSPAWN" and line[18] == "d":
		# 	spawn = line.split()[1][3:6]
		# 	position_x = int(spawn[0:1])
		# 	position_y = int(spawn[2])
		# 	last_spawn = (position_x, position_y)
		# 	#print("LASTSPAWN: ")
		# 	#print(last_spawn)

		# elif line[1:10] == "NEXTSPAWN":
		# 	spawn = line.split()[1][3:6]
		# 	position_x = int(spawn[0:1])
		# 	position_y = int(spawn[2])
		# 	next_spawn = (position_x, position_y)
			#print("NEXTSPAWN")
			#print(next_spawn)
			#spawn_list.append(next_spawn)

		

	#spawn_list.append(last_spawn)
	#print(spawn_list)
	#for i in range(0, len(spawn_list)):
		#spawn = spawn_list[i]
		#grid[spawn[0]][spawn[1]] = i*(-1)


# Parse one line from the sas file (solution)
# Find all important information and convey data to grid.
def next_turn(snake_length):
	next_x = 0
	next_y = 0
	last_x = 0
	last_y = 0
	line = sas.readline().strip()
	pos = line.find("pos")

	if pos == 6:
		line = line[16:19]
		next_x = int(line[0])
		next_y = int(line[2])

	elif pos == 20:
		line = line[30:47]
		next_x = int(line[0])
		next_y = int(line[2])

		#again looking for dummypoint.
		if line[14] == "m":
			pass

		else:
			spawn_x = int(line[14])
			spawn_y = int(line[16])
			grid[spawn_x][spawn_y] = -1

	elif pos == 23:
		line = line[33:36]
		next_x = int(line[0])
		next_y = int(line[2])

	else:
		print("NO MORE MOVES")
		# font = pygame.font.Font('freesansbold.ttf', 32)
		# text = font.render("No More Moves", True, (0,0,255), (125, 125, 0))
		# textRect = text.get_rect()
		# textRect.center = (display_x//2, display_y//2)
		# screen.fill((255,255,255))
		# screen.blit(text, textRect)
		return

	# Every field that contains snake, gets -1 to "let it move"
	# A new head is then set for "next_coordinates"
	for y in range(gridsize[1]):
		for x in range (gridsize[0]):
			if grid[x][y] > 0:
				if grid[x][y] == snake_length:
					last_x = x
					last_y = y
				grid[x][y] -=1
	#print(snake_length)
	header = (next_x - last_x, next_y - last_y)

	if grid[next_x][next_y] < 0:
		snake_length = snake_length +1
		
	grid[next_x][next_y] = snake_length

	#print("SNAKELENGTH: ", snake_length)
	newdraw(snake_length, header)

	return snake_length


# This method is not used currently due to newdraw() being prettier.
# Aims to normalize the colors as to give a sense of orientation.
# Here again the else-branch was for the case, that all foods would be read at the beginning
# There the 3 next foods would be displayed, but since the planner does not work like that,
# the conclusion was drawn to ignore that and simulate as the planner sees.
def normalize(value, snake_length):
	if value > 0:
		return (255/snake_length)*value
	else:
		return (255/3*(4+value))


# Older draw method, not in use.
# Much simpler representation and implementation than newdraw()
def draw(snake_length, header):
	print(grid)
	for y in range(gridsize[0]):
		for x in range (gridsize[1]):
			rect = pygame.Rect(x*blocksize_x, y*blocksize_y, blocksize_x, blocksize_y)
			if grid[y][x] == 0:
				pygame.draw.rect(screen, (0,0,0), rect)
			elif 0 > grid[y][x] and grid[y][x] > -4: #this might turn out to be unnecessary
				pygame.draw.rect(screen, (normalize(grid[y][x], snake_length),0,0),rect)
			elif grid[y][x] < -3:
				pygame.draw.rect(screen, (0,0,0),rect)
			else:  
				pygame.draw.rect(screen, (0,normalize(grid[y][x], snake_length),0), rect)


# Around a certain field grid[y][x], we look for the smallest bigger value.
# We learn the orientation of the body-parts of the snake.
def checkBigger(x, y, value):
	# This value just needs to be big enough, never to be reached, and +100 suffices.
	smallest = value + 100

	# Executing try-catch, since we may go out of bounds of the grid.
	try:
		if grid[y][x+1] > value and grid[y][x+1] < smallest:
			next_x = x+1
			next_y = y
			smallest = grid[y][x+1]
	except IndexError:
		None

	try:
		if grid[y][x-1] > value and grid[y][x-1] < smallest:
			next_x = x-1
			next_y = y
			smallest = grid[y][x-1]
	except IndexError:
		None

	try:
		if grid[y+1][x] > value and grid[y+1][x] < smallest:
			next_x = x
			next_y = y+1
			smallest = grid[y+1][x]
	except IndexError:
		None

	try:
		if grid[y-1][x] > value and grid[y-1][x] < smallest:
			next_x = x
			next_y = y-1
			smallest = grid[y-1][x]
	except IndexError:
		None
	#print(y,",",x)
	# We return a difference, to work with that.
	return (y-next_y, x-next_x)


# Around a certain field grid[y][x], we look for the biggest smaller value.
# We learn the orientation of the body-parts of the snake.
# The inner workings can be derived by looking at checkBigger()
def checkSmaller(x, y, value):
	biggest = value-100
	try:
		if grid[y][x+1] < value and grid[y][x+1] > biggest:
			last_x = x+1
			last_y = y
			biggest = grid[y][x+1]
	except IndexError:
		None

	try:
		if grid[y][x-1] < value and grid[y][x-1] > biggest:
			last_x = x-1
			last_y = y
			biggest = grid[y][x-1]
	except IndexError:
		None

	try:
		if grid[y+1][x] < value and grid[y+1][x] > biggest:
			last_x = x
			last_y = y+1
			biggest = grid[y+1][x]
	except IndexError:
		None

	try:
		if grid[y-1][x] < value and grid[y-1][x] > biggest:
			last_x = x
			last_y = y-1
			biggest = grid[y-1][x]
	except IndexError:
		None

	#print("Smaller: ",y-last_y,",", x-last_x)
	return (y-last_y, x-last_x)


# Advanced draw method displaying a snake and food on the display.
def newdraw(snake_length, header):
	# To check for correctness in the console.
	# Print the index for columns.
	print('\n'.join([''.join(['{:5}'.format(x) for x in range(gridsize[1])])]))
	
	# Go through all lines and first we add index of what line it is, then the content.
	for y in range(gridsize[0]):
		print(str(y)+ ''.join(['{:5}'.format(grid[y][x]) for x in range(gridsize[1])]))

	# for spacing
	print()
	# print(grid)
	# print()

	# Fill the screen with background color
	screen.fill((0,0,0))

	# Search for the smallest positive value.
	smallest = 100
	for x in range(gridsize[1]):
		for y in range(gridsize[0]):
			if grid[y][x] > 0 and grid[y][x] < smallest:
				smallest = grid[y][x]
				smallest_x = x
				smallest_y = y

			# If the position is representing a food, display the apple.
			if grid[y][x] == -1:
				# Load the picture locally and convert_alpha to make it faster and alpha since it's a png with transparency.
				image = pygame.image.load("apple.png").convert_alpha()
				# Reformat the picture according to the size of the window.
				image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
				# Get the rectangle dimensions
				rect = image.get_rect()
				# Define the place it is displayed
				rect.x = x*blocksize_x
				rect.y = y*blocksize_y
				# .blit allows us to draw existing display.
				screen.blit(image, rect)
				# we define the rectangle to draw, and set the flag to one.
				pygame.draw.rect(screen, (0,0,0), rect, 1)
				# we need to update the screen for the change to be visible.
				#pygame.display.update()

			# If the position is empty, no snake, no food, we can leave the background color.
			elif grid[y][x] == 0:
				pass

			# In case the position is equal to snake_length, that means it is the head.
			# We then look for the orientation of the head given by the variable header.
			elif grid[y][x] == snake_length:
				if header == (-1, 0):
					image = pygame.image.load("snake_04.png").convert_alpha()
					image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
					rect = image.get_rect()
					rect.x = x*blocksize_x
					rect.y = y*blocksize_y
					screen.blit(image, rect)
					pygame.draw.rect(screen, (0,0,0), rect, 1)
					#pygame.display.update()

				elif header == (+1, 0):
					image = pygame.image.load("snake_09.png").convert_alpha()
					image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
					rect = image.get_rect()
					rect.x = x*blocksize_x
					rect.y = y*blocksize_y
					screen.blit(image, rect)
					pygame.draw.rect(screen, (0,0,0), rect, 1)
					#pygame.display.update()

				elif header == (0, -1):
					image = pygame.image.load("snake_08.png").convert_alpha()
					image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
					rect = image.get_rect()
					rect.x = x*blocksize_x
					rect.y = y*blocksize_y
					screen.blit(image, rect)
					pygame.draw.rect(screen, (0,0,0), rect, 1)
					#pygame.display.update()

				elif header == (0, +1):
					image = pygame.image.load("snake_05.png").convert_alpha()
					image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
					rect = image.get_rect()
					rect.x = x*blocksize_x
					rect.y = y*blocksize_y
					screen.blit(image, rect)
					pygame.draw.rect(screen, (0,0,0), rect, 1)
					#pygame.display.update()

	# We need a new loop, since defining the smallest in the same loop as using it here: creates bugs.
	for x in range(gridsize[1]):
		for y in range(gridsize[0]):
			if grid[y][x] > smallest and grid[y][x] < snake_length:
				diff_smaller = checkSmaller(x,y,grid[y][x])
				diff_bigger = checkBigger(x,y,grid[y][x])
				#print(diff_bigger)
				#print(diff_smaller)
				diff_y = (diff_bigger[0], diff_smaller[0])
				diff_x = (diff_bigger[1], diff_smaller[1])
				#print(diff_x, ",", diff_y)

				# Checking for all middle-body-parts to be correct orientation
				# This considers the placing of smaller and bigger values in the grid, closest to the value
				# given by the grid position.
				# If considered to rework:
				# Need to rework the logic too, since updating a turn makes for gaps in the numbers.
				# If that is adjusted, this process could be optimized (less code and better performance.)
				if diff_x == (-1,0) and diff_y == (0,-1):
					image = pygame.image.load("snake_01.png").convert_alpha()
					image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
					rect = image.get_rect()
					rect.x = x*blocksize_x
					rect.y = y*blocksize_y
					screen.blit(image, rect)
					pygame.draw.rect(screen, (0,0,0), rect, 1)
					#pygame.display.update()

				elif diff_x == (-1,1) and diff_y == (0,0):
					image = pygame.image.load("snake_02.png").convert_alpha()
					image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
					rect = image.get_rect()
					rect.x = x*blocksize_x
					rect.y = y*blocksize_y
					screen.blit(image, rect)
					pygame.draw.rect(screen, (0,0,0), rect, 1)
					#pygame.display.update()

				elif diff_x == (0,1) and diff_y == (-1,0):
					image = pygame.image.load("snake_03.png").convert_alpha()
					image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
					rect = image.get_rect()
					rect.x = x*blocksize_x
					rect.y = y*blocksize_y
					screen.blit(image, rect)
					pygame.draw.rect(screen, (0,0,0), rect, 1)
					#pygame.display.update()

				elif diff_x == (0,0) and diff_y == (-1,1):
					image = pygame.image.load("snake_07.png").convert_alpha()
					image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
					rect = image.get_rect()
					rect.x = x*blocksize_x
					rect.y = y*blocksize_y
					screen.blit(image, rect)
					pygame.draw.rect(screen, (0,0,0), rect, 1)
					#pygame.display.update()

				elif diff_x == (1,0) and diff_y == (0,1):
					image = pygame.image.load("snake_10.png").convert_alpha()
					image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
					rect = image.get_rect()
					rect.x = x*blocksize_x
					rect.y = y*blocksize_y
					screen.blit(image, rect)
					pygame.draw.rect(screen, (0,0,0), rect, 1)
					#pygame.display.update()

				elif diff_x == (0,-1) and diff_y == (1,0):
					image = pygame.image.load("snake_06.png").convert_alpha()
					image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
					rect = image.get_rect()
					rect.x = x*blocksize_x
					rect.y = y*blocksize_y
					screen.blit(image, rect)
					pygame.draw.rect(screen, (0,0,0), rect, 1)
					#pygame.display.update()

				elif diff_x == (1,0) and diff_y == (1,0):
					image = pygame.image.load("snake_06.png").convert_alpha()
					image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
					rect = image.get_rect()
					rect.x = x*blocksize_x
					rect.y = y*blocksize_y
					screen.blit(image, rect)
					pygame.draw.rect(screen, (0,0,0), rect, 1)
					#pygame.display.update()

				elif diff_x == (0,-1) and diff_y == (-1,0):
					image = pygame.image.load("snake_01.png").convert_alpha()
					image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
					rect = image.get_rect()
					rect.x = x*blocksize_x
					rect.y = y*blocksize_y
					screen.blit(image, rect)
					pygame.draw.rect(screen, (0,0,0), rect, 1)
					#pygame.display.update()

				elif diff_x == (1,0) and diff_y == (0,-1):
					image = pygame.image.load("snake_03.png").convert_alpha()
					image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
					rect = image.get_rect()
					rect.x = x*blocksize_x
					rect.y = y*blocksize_y
					screen.blit(image, rect)
					pygame.draw.rect(screen, (0,0,0), rect, 1)
					#pygame.display.update()

				elif diff_x == (1,-1) and diff_y == (0,0):
					image = pygame.image.load("snake_02.png").convert_alpha()
					image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
					rect = image.get_rect()
					rect.x = x*blocksize_x
					rect.y = y*blocksize_y
					screen.blit(image, rect)
					pygame.draw.rect(screen, (0,0,0), rect, 1)
					#pygame.display.update()

				elif diff_x == (-1,0) and diff_y == (0,1):
					image = pygame.image.load("snake_06.png").convert_alpha()
					image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
					rect = image.get_rect()
					rect.x = x*blocksize_x
					rect.y = y*blocksize_y
					screen.blit(image, rect)
					pygame.draw.rect(screen, (0,0,0), rect, 1)
					#pygame.display.update()

				elif diff_x == (0,0) and diff_y == (1,-1):
					image = pygame.image.load("snake_07.png").convert_alpha()
					image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
					rect = image.get_rect()
					rect.x = x*blocksize_x
					rect.y = y*blocksize_y
					screen.blit(image, rect)
					pygame.draw.rect(screen, (0,0,0), rect, 1)
					#pygame.display.update()

				elif diff_x == (0,1) and diff_y == (1,0):
					image = pygame.image.load("snake_10.png").convert_alpha()
					image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
					rect = image.get_rect()
					rect.x = x*blocksize_x
					rect.y = y*blocksize_y
					screen.blit(image, rect)
					pygame.draw.rect(screen, (0,0,0), rect, 1)
					#pygame.display.update()


	# Looking for the orientation of the tail does not need a smaller object, only looking at bigger value.
	diff = checkBigger(smallest_x, smallest_y, smallest)

	# Here again checking all possible variations to display correct picture.
	if diff == (+1,0):
		image = pygame.image.load("snake_11.png").convert_alpha()
		image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
		rect = image.get_rect()
		rect.x = smallest_x*blocksize_x
		rect.y = smallest_y*blocksize_y
		screen.blit(image, rect)
		pygame.draw.rect(screen, (0,0,0), rect, 1)
		#pygame.display.update()

	elif diff == (-1,0):
		image = pygame.image.load("snake_14.png").convert_alpha()
		image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
		rect = image.get_rect()
		rect.x = smallest_x*blocksize_x
		rect.y = smallest_y*blocksize_y
		screen.blit(image, rect)
		pygame.draw.rect(screen, (0,0,0), rect, 1)
		#pygame.display.update()

	elif diff == (0,+1):
		image = pygame.image.load("snake_13.png").convert_alpha()
		image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
		rect = image.get_rect()
		rect.x = smallest_x*blocksize_x
		rect.y = smallest_y*blocksize_y
		screen.blit(image, rect)
		pygame.draw.rect(screen, (0,0,0), rect, 1)
		#pygame.display.update()

	elif diff == (0,-1):
		image = pygame.image.load("snake_12.png").convert_alpha()
		image = pygame.transform.smoothscale(image, (blocksize_x, blocksize_y))
		rect = image.get_rect()
		rect.x = smallest_x*blocksize_x
		rect.y = smallest_y*blocksize_y
		screen.blit(image, rect)
		pygame.draw.rect(screen, (0,0,0), rect, 1)
		#pygame.display.update()

	# One update to rule them all. (Small updates unneccesarry, since the updated info is a turn)
	pygame.display.update()




# This is the main script after we have introduced all the methods.
# First asking what problem should be solved, taking the input and using that.
# If "Enter" is pressed, the existing file sas would be used and the p01 file. 

print("What problem would you want solved? (Snake related)")
problem = input()

# Tested for p01.pddl or p06.pddl
# Some problems did not want to be solved by the planner and with that, 
# if no problem is solved, I cannot represent a solution.
if problem == "":
	p01 = open("p01.pddl", "r")
else:
	command = "./fast-downward.py domain.pddl " + problem
	command = command + ' --evaluator "hff=ff()" --search "lazy_greedy([hff], preferred=[hff])"'
	stream = os.popen(command)
	print(stream.read())
	p01 = open(problem, "r")


#os.system(command)

# Initializing everything needed.
snake_length = 2
spawn_list = list()

problem = p01.readline().split()
gridsize = (int(problem[2].split("-")[2][0]), int(problem[2].split("-")[2][2]))

# Looking for display-size and adjusting the window to display-size.
output = subprocess.Popen('xrandr | grep "\*" | cut -d" " -f4',shell=True, stdout=subprocess.PIPE).communicate()[0]
temp = min(int((int(output[0:4])-200)/gridsize[1]), int((int(output[5:9])-200)/gridsize[0]))
display_x = int(temp * gridsize[1])
display_y = int(temp * gridsize[0])
#print(display_x)
#print(display_y)

pygame.init()
screen = pygame.display.set_mode((display_x, display_y))
pygame.display.set_caption("Planned Snake")

#ProblemStellung


#gridsize[0] = rows 
#gridsize[1] = columns
grid = np.zeros((gridsize[0], gridsize[1]))
print(grid)
blocksize_x = int(display_x/gridsize[1])
blocksize_y = int(display_y/gridsize[0])
sas = open("sas_plan", "r")

# After having all variables.
header = initialize()

#Loesung
#sas = open("sas_plan", "r")
#print(sas.readline())

newdraw(snake_length, header)

# Update the display and check for inputs.
# Let the window be open for as long, as the close-window-button is not clicked.
run = True
while run:
	for event in pygame.event.get():
		if event.type == pygame.QUIT:
			# Quit if red x is pressed.
			run = False

		elif event.type == pygame.MOUSEBUTTONUP:
			if event.button == 1:
				# When clicking the left mouse button, trigger the next turn to be displayed.
				snake_length = next_turn(snake_length)

	pygame.display.update()

# When the loop is terminated, the program stops.
pygame.quit()
