sigma_operands = []
join_table = []


def translate(content):
    global sigma_operands
    global join_table
    sigma_operands = []
    join_table = []
    selection = content[content.find("{") + 1:content.find("|")].split(", ")
    rest = content.split("|")[1][:-1]
    sel_name = []
    identifier = []
    for sel in selection:
        identifier.append(sel.split(".")[0])
        sel_name.append(sel.split(".")[1])

    tables = extract_tables(rest)
    extract_operands(rest, " = ")
    extract_operands(rest, " < ")
    extract_operands(rest, " > ")
    extract_operands(rest, " >= ")
    extract_operands(rest, " <= ")
    extract_operands(rest, " != ")
    result = "\pi["
    for i, sel in enumerate(sel_name):
        result = result + sel
        if i < len(sel_name) - 1:
            result = result + ","


    result += "](\sigma["
    for i, op in enumerate(sigma_operands):
        result += op
        if i < len(sigma_operands) - 1:
            result += " \land "
    result = result + "]"
    for i, table in enumerate(tables):
        result = result + "(" + tables[table] + ")"
        if i < len(tables) - 1:
            result += "\\bowtie"
    result += ")"
    return result


def extract_tables(content):
    tables = {}
    rest_split = content.split(" \in ")
    for i, split in enumerate(rest_split):
        if i < len(rest_split) - 1:
            a = rest_split[i].split(" ")[-1]
            b = rest_split[i + 1].split(" ")[0]
            tables[a] = b
    return tables


def extract_operands(content, operand):
    rest_split = content.split(operand)
    for i, split in enumerate(rest_split):
        if i < len(rest_split) - 1:
            a = rest_split[i].split(" ")[-1]
            b = rest_split[i + 1].split(" ")[0]
            if a.find(".") != -1 and b.find(".") != -1 and operand == " = ":
                join_table.append((a, b))
            else:
                a = a[a.find(".") + 1:]
                b = b[b.find(".") + 1:]
                sigma_operands.append(a + operand + b)



if __name__ == '__main__':
    print(translate("{c.Name|c \in Customers \land c.Balance < 0.0}"))
    print(translate("{c.Name| c \in Customers \land \exists_o o \in Orders \land c.CID = o.CID \land o.Status != 'paid' \land o.Month < 10}"))
    print(translate("{c.Name, p.Label| c \in Customers \land p \in Products \land \exists_o o \in Orders \land o.CID = c.CID \land o.PID = p.PID \land c.City = 'Basel' \land p.Location = 'Basel' \land o.Status = 'delivered' \land o.Month >= 9}"))
