import re

join = []
selection = []
tables = []
sigma = []
sigma_operands = []
table_id = []
all_join = []


def translate(content):
    extract_joinwith(content)
    extract_selection(content)
    extract_tables(content)
    extract_sigma(content)
    result = "\\{" + selection + "|"
    tables_joined = ""
    for i, t in enumerate(tables):
        tables_joined += table_id[i] + " \in " + t
        if i < len(tables) - 1:
            tables_joined += " \land "
    result += tables_joined
    for j in all_join:
        result += " \land " + j

    for i, s in enumerate(sigma):
        if i == 0:
            result += " \land "
        result += s
        if i < len(sigma) - 1:
            result += " \land "
    result += "\\}"
    return result


def extract_joinwith(content):
    global join
    join = []
    join = re.findall(r'\{(.*?)}', content)
    global all_join
    all_join = []
    for j in join:
        all_join.extend(j.split(","))


def extract_selection(content):
    global selection
    selection = []
    selection = re.search(r'\\pi\[(.*?)]', content).group(1)


def extract_tables(content):
    global tables
    tables = []
    tables = re.findall(r'\((\w*?)\)', content)
    global table_id
    table_id = []
    for t in tables:
        table_id.append(t[0].lower())



def extract_sigma(content):
    global sigma
    sigma = []
    sigma = re.findall(r'\\sigma\[(.*?)]', content)
    global sigma_operands



if __name__ == '__main__':
    print(translate("\pi[Name](\sigma[Balance<0.0](Customers))"))
    print(translate("\pi[Name](\sigma[Status != 'paid' \land Month<10](Orders)\\bowtie(Customers){c.CID = o.CID, f.CID = h.CID}"))
    print(translate("\pi[Name](\sigma[Location = 'Basel'](Products)\\bowties(\sigma[Status = 'delivered' \land Month >= 9](Orders))\\bowtie(\sigma[City = 'Basel'](Customers)))"))
    print(translate("\pi[Name, Label](\sigma[Status != 'paid' \land Month < 10](Orders)\\bowtie(Customers){c.CID = o.CID}"))
