import PySimpleGUI as sg
import algtocalc, calctoalg
import subprocess


def main():
    layout = [
        [sg.Text('Please enter the formula you want to translate (LaTeX format required)')],
        [sg.Text('Input Formula', size=(15, 1)), sg.InputText()],
        [sg.Checkbox('Alg to Calc'), sg.Checkbox('Calc to Alg')],
        [sg.Text('Output Formula', size=(15, 1)), sg.Output(key='translatedFormula')],
        [sg.Text('Output Compiled', size=(15, 1)), sg.Output(key='LaTeX')],
        [sg.Submit(button_text='Translate')]
    ]

    window = sg.Window('Relational Translator', layout)
    while True:
        event, values = window.read()
        values[0] = values[0].strip()
        if (values[1] and values[2]) or (not values[1] and not values[2]):
            sg.Popup('Please check exactly one box')
        if event == 'Translate' and values[1] and not values[2]:
            if values[0][0] != "\\":
                sg.Popup('this is not an algebraic expression')
            else:
                try:
                    generate_latex(algtocalc.translate(values[0]))
                    window.Element('LaTeX').Update('generated LaTex file as output.tex and pdf as output.pdf')
                except:
                    window.Element('LaTeX').Update('No latex compiler found on your system')
                window.Element('translatedFormula').Update(algtocalc.translate(values[0]))
        if event == 'Translate' and values[2] and not values[1]:
            if values[0][0] != "{":
                sg.Popup('this is not a calculus expression')
            else:
                try:
                    generate_latex(calctoalg.translate(values[0]))
                    window.Element('LaTeX').Update('generated LaTex file as output.tex and pdf as output.pdf')
                except:
                    window.Element('LaTeX').Update('No latex compiler found on your system')
                window.Element('translatedFormula').Update(calctoalg.translate(values[0]))
        if event == sg.WIN_CLOSED:
            break
    window.close()


def generate_latex(content):
    with open("output.tex", "w") as file:
        file.write("\\documentclass{article}\n")
        file.write("\\begin{document}\n")
        file.write("$" + content + "$")
        file.write("\\end{document}\n")
    command = "pdflatex output.tex"
    process = subprocess.Popen(command.split(), stdout=subprocess.PIPE)
    output, error = process.communicate()
    print(f"output: {output}")
    print(f"error: {error}")


if __name__ == '__main__':
    main()
