import Statement

class WhileStatement(Statement.Statement):

    def __init__(self, branchingCondition, body, invariant):
        '''
        While statement of the form:
        WHILE branchingCondition
        {invariant}
        body
        END
        '''
        self.branchingCondition = branchingCondition
        self.body = body
        self.invariant = invariant
        self.wlpBody = ''
        self.intermediatePreBody = []

    def wlp(self, postcondition) -> str:
        '''
        wlp = invariant and (not(B and I) or wlp(body, I)) and (not(not B and I) or postcondition)
        '''
        from Verifier import Verifier

        verifier = Verifier('', self.invariant, [], self.body, True)
        verifier.derivePrecondition()
        self.wlpBody = verifier.derivedPre
        self.intermediatePreBody = verifier.intermediatePreconditions
        term1 = '(!(' + self.branchingCondition + ' && ' + self.invariant + ') || (' + self.wlpBody + '))'
        term2 = '(!(!' + self.branchingCondition + ' && ' + self.invariant + ') || ' + postcondition + ')'

        return self.invariant + ' && ' + term1 + ' && ' + term2


    def print(self):
        print('WHILE ' + self.branchingCondition)
        print('{' + self.wlpBody + '}')
        for i in range(len(self.body)):
            self.body[i].print()
            print('{' + self.intermediatePreBody[i] + '}')

        print('END')