from Verifier import Verifier
import Statement

class IfStatement(Statement.Statement):

    def __init__(self, branchingCondition, c1, c2):
        '''
        if statement of the form:
        IF branchingCondition
        C1
        END
        ELSE
        C2
        END
        '''
        self.branchingCondition = branchingCondition
        self.c1 = c1
        self.c2 = c2


    def wlp(self, postcondition) -> str:
        '''
        wlp(self, postcondition) = ((branchingCondition => wlp(self.C1, postcondition)) and (not B => wlp(self.C2, postcondition))

        Source: https://arxiv.org/pdf/1708.07223.pdf
        '''

        verifierIF = Verifier('', postcondition, [], self.c1, True)
        verifierIF.derivePrecondition()
        verifierELSE = Verifier('', postcondition, [], self.c2, True)
        verifierELSE.derivePrecondition()
        self.wlpC1 = verifierIF.derivedPre
        self.intermediatePreC1 = verifierIF.intermediatePreconditions
        self.wlpC2 = verifierELSE.derivedPre
        self.intermediatePreC2 = verifierELSE.intermediatePreconditions

        resultingWlp = '(!(' + self.branchingCondition + ')||(' + self.wlpC1 + '))&&((' + self.branchingCondition + ')||(' + self.wlpC2 + '))'

        return resultingWlp


    def print(self):
        print('IF ' + self.branchingCondition)
        print('{' + self.wlpC1 + '}')
        for i in range(len(self.c1)):
            self.c1[i].print()
            print('{' + self.intermediatePreC1[i] + '}')

        print('END ELSE')
        print('{' + self.wlpC2 + '}')
        for i in range(len(self.c2)):
            self.c2[i].print()
            print('{' + self.intermediatePreC2[i] + '}')
        print('END')