from Reader import Reader
from Parser import Parser
from Verifier import Verifier

#path = "../inputCases/inputSimple.txt"
path = "../inputCases/input1.txt"
#path = "../inputCases/inputOnlyStrings.txt"

# Option to analyze only strings. If set to True it will not use cplex to verify results
onlyStrings = False

# read input
r = Reader()
triple = r.readFromTxt(path)

# parse input into statements and conditions
parser = Parser(onlyStrings)
pre, post, variables, statements, i = parser.parseProgram(triple, True)

# derive preconditions and print the results
verifier = Verifier(pre, post, variables, statements, onlyStrings)
verifier.derivePrecondition()
verifier.printResults()

# use cplex to verify the initial Hoare triple (only if onlyStrings is set to False)
if not onlyStrings:
    verifier.testCplex()