import re
import Statement
from PPCondition import PPCondition

class Assignment(Statement.Statement):

    def __init__(self, left, right, isString=False):
        self.leftHandSide = left
        self.rightHandSide = right
        self.isString = isString


    def getLeftHandSide(self) -> str:
        return self.leftHandSide

    def getRightHandSide(self) -> str:
        return self.rightHandSide

    '''
    takes a postcondition and returns a precondition by replacing
    all occurrences of the left hand side in the postcondition
    with the right hand side
    '''
    def wlp(self, postcondition) -> list:
        if self.isString:
            postList = re.sub('(\W)', " \\1 ", postcondition).split()
            postListReplaced = ['(' + self.rightHandSide + ')' if e == self.leftHandSide else e for e in postList]
            # precondition = post.replace(self.leftHandSide, '(' + self.rightHandSide + ')')
            return ''.join(postListReplaced)
        else:
            wlp = []
            for condition in postcondition:
                # add whitespaces to split both left hand side and right hand side
                leftSideSplit = re.sub('(\W)', ' \\1 ', condition.left).split()
                rightSideSplit = re.sub('(\W)', ' \\1 ', condition.right).split()
                # substitute variables on the left and on the right of the condition
                leftReplaced = ['(' + self.rightHandSide + ')' if e == self.leftHandSide else e for e in leftSideSplit]
                rightReplaced = ['(' + self.rightHandSide + ')' if e == self.leftHandSide else e for e in rightSideSplit]

                # create new condition
                newWLP = PPCondition(''.join(leftReplaced), condition.comp, ''.join(rightReplaced))
                newWLP.simplifyCondition()
                wlp.append(newWLP)

            return wlp


        '''
        postList = re.sub('(\W)', " \\1 ", postcondition).split()
        postListReplaced = ['(' + self.rightHandSide + ')' if e == self.leftHandSide else e for e in postList]
        #precondition = post.replace(self.leftHandSide, '(' + self.rightHandSide + ')')
        return ''.join(postListReplaced)
        '''

    def print(self):
        r = self.rightHandSide.replace('+', ' + ')     #.replace('*', ' * ').replace('/', ' / ')
        print(self.leftHandSide + " = " + r)


