import java.util.Random;
import java.lang.StringBuilder;

public class CrazyRandomSelector {

    Random r;
    StringBuilder stringBuilder;
    CharDB charDB;

    /**
     * Constructor setting up the random Objet.
     */
    public CrazyRandomSelector(CharDB db) {
        this.charDB = db;
        this.r = new Random();
    }

    /**
     * Creates a random String between length three and seven.
     * @return the randomly generated String.
     */
    public String getCrazyRandomSelection() {
        int i = r.nextInt(3) + 4;

        stringBuilder = new StringBuilder("");
        for (int j = 0; j < i; j++) {
            stringBuilder.append(charDB.getCharAt(this.r.nextInt(62)));
        }
        return stringBuilder.toString();
    }

    /**
     * creates a random String of length 'i'.
     * @param i length of the random String
     * @return the random String
     */
    public String getCrazyRandomSelection(int i) {
        stringBuilder = new StringBuilder("");
        for (int j = 0; j < i; j++) {
            stringBuilder.append(charDB.getCharAt(this.r.nextInt(62)));
        }
        return stringBuilder.toString();
    }
}
