import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;

public class CaptchaWindow extends JFrame {

    Handler handler;

    JTextField question;
    JTextField answer;
    JTextField captchaField;
    JButton button;
    public String solution;

    public CaptchaWindow (String captcha) {
        super("Solve the CAPTCHA!");
        setLayout(new FlowLayout());
        setSize(300, 150);
        setLocationRelativeTo(null);

        handler = new Handler();

        question = new JTextField("Solve the CAPTCHA: ");
        question.setEditable(false);
        add(question);

        captchaField = new JTextField(captcha);
        captchaField.setEditable(false);
        captchaField.setLocation(new Point(this.getWidth()/2, this.getHeight()/2));
        captchaField.setFont(new Font(Font.SERIF, Font.BOLD, 18));
        add(captchaField);

        answer = new JTextField(20);
        add(answer);
        answer.addActionListener(handler);

        button = new JButton("Solve");
        add(button);
        button.addActionListener(handler);

        setVisible(true);

        solution = "";

        Captcha.humanSolver = new HumanSolver(captcha);
        Captcha.botSolver = new BotSolver(captcha);

        Captcha.humanSolver.start();
        Captcha.botSolver.start();
    }

    public void showResult(String botTime) {
        JOptionPane.showMessageDialog(null, botTime, "Solved!", JOptionPane.INFORMATION_MESSAGE);
        this.dispatchEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));
    }

    private class Handler implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {

            if (e.getSource()==button) {
                solution = answer.getText();
                answer.setText("Try again");
                answer.requestFocus();
                answer.selectAll();
            }
        }
    }
}
