import java.lang.Thread;

public class BotSolver extends Thread {

    String captcha;
    StringBuilder bruteForce;
    double totalTime;
    double startingTime;
    boolean solved = false;

    public BotSolver(String s) {
        this.captcha = s;
        this.bruteForce = new StringBuilder(captcha.length());
        this.bruteForce.append("0".repeat(captcha.length()));
    }

    @Override
    public void run() {

        startingTime = System.currentTimeMillis();

        while (!solved) {
            combine(this.bruteForce, 0);
        }
    }

    public void combine(StringBuilder s, int i) {

        for (int j = 49; j < 123; j++) {
            switch (j) {
                case 58:
                    j = 65;
                    break;
                case 91:
                    j = 97;
                    break;
                }
            s.setCharAt(i, (char) j);
            //System.out.println(s.toString());
            if (s.toString().equals(captcha) && !solved) {
                solved = true;
                totalTime = System.currentTimeMillis() - this.startingTime;
                //System.out.println(totalTime);
                break;
            } else if (Captcha.humanSolver.solved) {
                break;
            }

            if (i + 1 < captcha.length()) {
                combine(s, i + 1);
            }
        }
        s.setCharAt(i, (char)48);
    }

    public String printBotTime() {
        if (solved) {
            if (this.totalTime < 1000.00) {
                return ("Correct, the bot took " + this.totalTime + " ms.");
            } else {
                return ("Correct, the bot took " + this.totalTime/1000.00 + " s.");
            }
        } else return("Congratulations! The bot has not solved this captcha yet...");
    }
}
