;; blocks world domain

(define (domain blocks-world)
  (:requirements :strips :action-costs)

  (:predicates (on ?b1 ?b2)
	       (on-table ?b)
	       (clear ?b)
	       )

  (:functions (total-cost) - number)

  (:action move
   :parameters (?moved-block ?current-block-below ?new-block-below)
   :precondition (and (on ?moved-block ?current-block-below)
                      (clear ?moved-block)
                      (clear ?new-block-below))
   :effect (and (on ?moved-block ?new-block-below)
                (clear ?current-block-below)
                (not (on ?moved-block ?current-block-below))
                (not (clear ?new-block-below))
                (increase (total-cost) 1)))

  (:action to-table
   :parameters (?moved-block ?current-block-below)
   :precondition (and (on ?moved-block ?current-block-below)
                      (clear ?moved-block))
   :effect (and (on-table ?moved-block)
                (clear ?current-block-below)
                (not (on ?moved-block ?current-block-below))
                (increase (total-cost) 1)))

  (:action from-table
   :parameters (?moved-block ?new-block-below)
   :precondition (and (on-table ?moved-block)
                      (clear ?moved-block)
                      (clear ?new-block-below))
   :effect (and (on ?moved-block ?new-block-below)
                (not (on-table ?moved-block))
                (not (clear ?new-block-below))
                (increase (total-cost) 1)))
)
