#! /usr/bin/env python3
# -*- coding: utf-8 -*-

import random

blocks = list("abcdefghijklmnopqrstuvwxyz")
random.shuffle(blocks)

towers = []
curr_tower = []
for block in blocks:
    if curr_tower and random.choice([False, True]):
        towers.append(curr_tower)
        curr_tower = []
    curr_tower.append(block)
towers.append(curr_tower)

for tower in towers:
    print(f"   (clear {tower[0]})")
    for above, below in zip(tower, tower[1:]):
        print(f"   (on {above} {below})")
    print(f"   (on-table {tower[-1]})")
