(define (domain sokoban)
  (:requirements :typing)

  (:types
    location direction box - object
  )

  (:predicates
    (IS-GOAL ?l - location)
    (MOVE-DIR ?from - location ?to - location ?dir - direction)

    (clear ?l - location)
    (box-at ?b - box ?l - location)
    (agent-at ?l - location)
    (at-goal ?b - box)
  )

  (:functions
    (total-cost) - number
  )

  (:action move
   :parameters
     (?from - location
      ?to - location
      ?dir - direction
     )
   :precondition
     (and
       ;; add the missing preconditions
     )
   :effect
     (and
       ;; add the missing effects
       (increase (total-cost) 0)
     )
  )

  (:action push-to-nongoal
   :parameters
     (?b - box
      ?apos - location
      ?from - location
      ?to - location
      ?dir - direction
     )
   :precondition
     (and
       ;; add the missing preconditions
     )
   :effect
     (and
       ;; add the missing effects
       (increase (total-cost) 1)
     )
   )

  (:action push-to-goal
   :parameters
     (?b - box
      ?apos - location
      ?from - location
      ?to - location
      ?dir - direction
     )
   :precondition
     (and
       ;; add the missing preconditions
     )
   :effect
     (and
       ;; add the missing effects
       (increase (total-cost) 1)
     )
   )
)
