import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

import java.util.ArrayList;
import java.util.Random;

public class HillClimbing {
    protected CombinatorialOptimizationProblem cop;

    private class SearchResult {
        boolean success;
        int steps;

        public SearchResult(boolean success, int steps) {
            this.success = success;
            this.steps = steps;
        }
    }

    public HillClimbing(String args[]) {
        if (args.length == 0) {
            Errors.usageError("no combinatorial optimization problem given");
        }

        if (args[0].equals("8queens")) {
            cop = new EightQueensProblem();
        } else {
            Errors.usageError("unknown combinatorial optimization problem: " + args[0]);
        }
    }

    protected SearchResult search() {
        // TODO: Implement hill climbing here. Remember that our
        // implementation differs from the one presented in the lecture
        // in the fact that we are dealing with a minimization problem
        // rather than a maximization problem.

    }

    public static void main(String args[]) {
        HillClimbing hc = new HillClimbing(args);
        int successfulRuns = 0;
        int steps = 0;
        int runs = 1000;
        for (int i = 0; i < runs; i++) {
            SearchResult result = hc.search();
            if (result.success) {
                successfulRuns++;
            }
            steps += result.steps;
        }
        System.out.println("Percentage of successful runs: "
                           + ((double) successfulRuns)/runs * 100 + "%");
        System.out.println("Average number of steps in successful runs: "
                           + ((double) steps)/runs);
    }
}
