;; 8-puzzle example problem with initial state:
;;
;; -------------
;; | 2 |   | 7 |
;; -------------
;; | 4 | 5 | 8 |
;; -------------
;; | 1 | 6 | 3 |
;; -------------

(define (problem sliding-tile-puzzle-example)

  (:domain sliding-tile-puzzle)

  (:objects
    tile1 - tile
    tile2 - tile
    tile3 - tile
    tile4 - tile
    tile5 - tile
    tile6 - tile
    tile7 - tile
    tile8 - tile

    row1 - row
    row2 - row
    row3 - row

    column1 - column
    column2 - column
    column3 - column
  )

  (:init
    (ROW-ABOVE row1 row2)
    (ROW-ABOVE row2 row3)

    (COLUMN-LEFT column1 column2)
    (COLUMN-LEFT column2 column3)

    (tile-at tile2 row1 column1)
    (is-blank      row1 column2)
    (tile-at tile7 row1 column3)
    (tile-at tile4 row2 column1)
    (tile-at tile5 row2 column2)
    (tile-at tile8 row2 column3)
    (tile-at tile1 row3 column1)
    (tile-at tile6 row3 column2)
    (tile-at tile3 row3 column3)

    (= (total-cost) 0)
  )

  (:goal (and
    (tile-at tile1 row1 column1)
    (tile-at tile2 row1 column2)
    (tile-at tile3 row1 column3)
    (tile-at tile4 row2 column1)
    (tile-at tile5 row2 column2)
    (tile-at tile6 row2 column3)
    (tile-at tile7 row3 column1)
    (tile-at tile8 row3 column2)
  ))

  (:metric minimize (total-cost))
)
