# -*- coding: utf-8 -*-

import random


class PuzzleStateSpace(object):
    NUM_ROWS = 3
    NUM_COLUMNS = 3
    NUM_POS = NUM_ROWS * NUM_COLUMNS
    GOAL_STATE = tuple([None, 1, 2, 3, 4, 5, 6, 7, 8])

    def __init__(self, initial_state=None):
        if initial_state is None:
            initial_state = list(self.GOAL_STATE)
            random.shuffle(initial_state)
            # Note: can generate unsolvable instances!

        self.initial_state = tuple(initial_state)
        if len(self.initial_state) != self.NUM_POS:
            raise ValueError
        if set(self.initial_state) != set(self.GOAL_STATE):
            raise ValueError

    def get_initial_state(self):
        return self.initial_state

    def is_goal(self, state):
        return state == self.GOAL_STATE

    def get_successors(self, state):
        blank_pos = state.index(None)
        row, column = self._pos_to_row_column(blank_pos)

        def succ_state(delta):
            new_state = list(state)
            new_state[blank_pos], new_state[blank_pos + delta] = (
                new_state[blank_pos + delta], new_state[blank_pos])
            return tuple(new_state)

        result = []
        if column > 0:
            result.append(("left", succ_state(-1)))
        if column + 1 < self.NUM_COLUMNS:
            result.append(("right", succ_state(+1)))
        if row > 0:
            result.append(("up", succ_state(-self.NUM_COLUMNS)))
        if row + 1 < self.NUM_ROWS:
            result.append(("down", succ_state(+self.NUM_COLUMNS)))
        return result

    def get_action_cost(self, action):
        return 1

    def _pos_to_row_column(self, pos):
        return divmod(pos, self.NUM_COLUMNS)
