package recursion;

public abstract class Function {
    private final int arity;

    public Function(int arity) {
        this.arity = arity;
    }

    public final int compute(int[] args) {
        if (args.length != arity) {
            throw new RuntimeException("Function expects "
                + arity + " parameters but was called with "
                + args.length + " parameters.");
        }
        return computeValue(args);
    }

    public int getArity() {
        return arity;
    }

    protected abstract int computeValue(int[] args);
}
