package turingmachine;

/**
 * This class is a basic wrapper around int with the interface restricted
 * to what we need for states.
 * Two states are the same iff they have the same number.
 */
public final class State {
    private final int id;

    public State(int id) {
        this.id = id;
    }

    public String toString() {
        return "q" + id;
    }

    /**
     * We have to override hashCode() since we override equals().
     */
    @Override
    public int hashCode() {
        return id;
    }

    /**
     * Two states are equal iff they have the same id.
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (!(obj instanceof State))
            return false;
        State other = (State) obj;
        return (id == other.id);
    }
}
