package turingmachine;

/**
 * A transition function maps tuples (q, a) to tuples (q', b, d), where
 *     q is a state from Q \ E
 *     q' is a state from Q
 *     a and b are symbols from Gamma
 *     d is a direction from {L, R, N}
 *
 * The class TransitionEffect represents the effect (q', b, d) that a transition
 * has, i.e., the next state q', the symbol b to write, and the direction d in which
 * to move the head.
 * We never compare or hash TransitionEffect objects, so we do not need to override
 * equals() or hashCode().
 */
public final class TransitionEffect {
    private final State state;
    private final Symbol symbol;
    private final Direction direction;

    public TransitionEffect(State state, Symbol symbol, Direction direction) {
        assert(state != null);
        assert(symbol != null);
        assert(direction != null);
        this.state = state;
        this.symbol = symbol;
        this.direction = direction;
    }

    public State getState() {
        return state;
    }

    public Symbol getSymbol() {
        return symbol;
    }

    public Direction getDirection() {
        return direction;
    }
}
