package turingmachine;

/**
 * A transition function maps tuples (q, a) to tuples (q', b, d), where
 *     q is a state from Q \ E
 *     q' is a state from Q
 *     a and b are symbols from Gamma
 *     d is a direction from {L, R, N}
 *
 * The class TransitionCondition represents the condition (q, a) under which a
 * transition can be used, i.e., the current state q and the symbol a under the head.
 */
public final class TransitionCondition {
    private final State state;
    private final Symbol symbol;

    public TransitionCondition(State state, Symbol symbol) {
        assert(state != null);
        assert(symbol != null);
        this.state = state;
        this.symbol = symbol;
    }

    public State getState() {
        return state;
    }

    public Symbol getSymbol() {
        return symbol;
    }

    /**
     * We have to override hashCode() since we override equals().
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + state.hashCode();
        result = prime * result + symbol.hashCode();
        return result;
    }

    /**
     * Two TransitionCondition objects are equal iff their components are equal.
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TransitionCondition))
            return false;
        TransitionCondition other = (TransitionCondition) obj;
        return state.equals(other.state) && symbol.equals(other.symbol);
    }
}
