package recursion.schema;

import recursion.Function;

public class Composition extends Function {
    private final Function h;
    private final Function[] gs;

    public Composition(int k, int i, Function h, Function[] gs) {
        super(k);
        if (i != gs.length || i < 1) {
            throw new RuntimeException("The parameter i of a subtitution should match the number"
                + " of component functions and there should be at least one such function"
                + " Tried to create a composition with i = " + i
                + " and " + gs.length + " component functions");
        }

        if (h.getArity() != i) {
            throw new RuntimeException("Tried to apply composition schema that uses "
                + gs.length + " functions as input for a function with arity " + h.getArity());
        }
        for (Function g : gs) {
            if (g.getArity() != k) {
                throw new RuntimeException("Tried to apply composition schema that uses "
                    + "some component functions with arity " + k + " and some components "
                    + "with arity " + g.getArity());
            }
        }
        this.h = h;
        this.gs = gs;
    }

    @Override
    protected int computeValue(int[] args) {
        int[] hArgs = new int[h.getArity()];
        for (int i = 0; i < gs.length ; ++i) {
            hArgs[i] = gs[i].compute(args);
        }
        return h.compute(hArgs);
    }
}
